/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.plot.iterationlistener;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.optimize.api.IterationListener;
import org.deeplearning4j.util.ImageLoader;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.ops.transforms.Transforms;

public class ActivationMeanIterationListener
implements IterationListener {
    private int iteration = 1;
    private File outputFile = new File("activations.png");

    public ActivationMeanIterationListener(int iteration) {
        this.iteration = iteration;
    }

    public int getIteration() {
        return this.iteration;
    }

    public void setIteration(int iteration) {
        this.iteration = iteration;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    @Override
    public boolean invoked() {
        return false;
    }

    @Override
    public void invoke() {
    }

    @Override
    public void iterationDone(Model model, int iteration) {
        if (iteration % this.iteration == 0) {
            Layer l = (Layer)model;
            INDArray activationMean = l.activate();
            INDArray weights = Transforms.sigmoid((INDArray)activationMean);
            BufferedImage image = ImageLoader.toImage(weights);
            try {
                ImageIO.write((RenderedImage)image, "png", this.outputFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

