/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.optimize;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.optimize.api.ConvexOptimizer;
import org.deeplearning4j.optimize.api.IterationListener;
import org.deeplearning4j.optimize.api.StepFunction;
import org.deeplearning4j.optimize.solvers.ConjugateGradient;
import org.deeplearning4j.optimize.solvers.LBFGS;
import org.deeplearning4j.optimize.solvers.LineGradientDescent;
import org.deeplearning4j.optimize.solvers.StochasticGradientDescent;
import org.deeplearning4j.optimize.solvers.StochasticHessianFree;
import org.deeplearning4j.optimize.stepfunctions.StepFunctions;

public class Solver {
    private NeuralNetConfiguration conf;
    private Collection<IterationListener> listeners;
    private Model model;
    private ConvexOptimizer optimizer;
    private StepFunction stepFunction;

    public void optimize() {
        if (this.optimizer == null) {
            this.optimizer = this.getOptimizer();
        }
        this.optimizer.optimize();
    }

    public ConvexOptimizer getOptimizer() {
        switch (this.conf.getOptimizationAlgo()) {
            case LBFGS: {
                return new LBFGS(this.conf, this.stepFunction, this.listeners, this.model);
            }
            case LINE_GRADIENT_DESCENT: {
                return new LineGradientDescent(this.conf, this.stepFunction, this.listeners, this.model);
            }
            case HESSIAN_FREE: {
                return new StochasticHessianFree(this.conf, this.stepFunction, this.listeners, this.model);
            }
            case CONJUGATE_GRADIENT: {
                return new ConjugateGradient(this.conf, this.stepFunction, this.listeners, this.model);
            }
            case STOCHASTIC_GRADIENT_DESCENT: {
                return new StochasticGradientDescent(this.conf, this.stepFunction, this.listeners, this.model);
            }
        }
        throw new IllegalStateException("No optimizer found");
    }

    public static class Builder {
        private NeuralNetConfiguration conf;
        private Model model;
        private List<IterationListener> listeners = new ArrayList<IterationListener>();

        public Builder configure(NeuralNetConfiguration conf) {
            this.conf = conf;
            return this;
        }

        public Builder listener(IterationListener ... listeners) {
            this.listeners.addAll(Arrays.asList(listeners));
            return this;
        }

        public Builder listeners(Collection<IterationListener> listeners) {
            this.listeners.addAll(listeners);
            return this;
        }

        public Builder model(Model model) {
            this.model = model;
            return this;
        }

        public Solver build() {
            Solver solver = new Solver();
            solver.conf = this.conf;
            solver.stepFunction = StepFunctions.createStepFunction(this.conf.getStepFunction());
            solver.model = this.model;
            solver.listeners = this.listeners;
            return solver;
        }
    }
}

