/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.optimize.solvers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.exception.InvalidStepException;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.api.Updater;
import org.deeplearning4j.nn.conf.LearningRatePolicy;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.updater.UpdaterCreator;
import org.deeplearning4j.nn.updater.graph.ComputationGraphUpdater;
import org.deeplearning4j.optimize.api.ConvexOptimizer;
import org.deeplearning4j.optimize.api.IterationListener;
import org.deeplearning4j.optimize.api.StepFunction;
import org.deeplearning4j.optimize.api.TerminationCondition;
import org.deeplearning4j.optimize.solvers.BackTrackLineSearch;
import org.deeplearning4j.optimize.solvers.StochasticGradientDescent;
import org.deeplearning4j.optimize.stepfunctions.NegativeDefaultStepFunction;
import org.deeplearning4j.optimize.stepfunctions.NegativeGradientStepFunction;
import org.deeplearning4j.optimize.terminations.EpsTermination;
import org.deeplearning4j.optimize.terminations.ZeroDirection;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseOptimizer
implements ConvexOptimizer {
    protected NeuralNetConfiguration conf;
    protected int iteration = 0;
    protected static final Logger log = LoggerFactory.getLogger(BaseOptimizer.class);
    protected StepFunction stepFunction;
    protected Collection<IterationListener> iterationListeners = new ArrayList<IterationListener>();
    protected Collection<TerminationCondition> terminationConditions = new ArrayList<TerminationCondition>();
    protected Model model;
    protected BackTrackLineSearch lineMaximizer;
    protected Updater updater;
    protected ComputationGraphUpdater computationGraphUpdater;
    protected double step;
    private int batchSize;
    protected double score;
    protected double oldScore;
    protected double stepMax = Double.MAX_VALUE;
    public static final String GRADIENT_KEY = "g";
    public static final String SCORE_KEY = "score";
    public static final String PARAMS_KEY = "params";
    public static final String SEARCH_DIR = "searchDirection";
    protected Map<String, Object> searchState = new ConcurrentHashMap<String, Object>();

    public BaseOptimizer(NeuralNetConfiguration conf, StepFunction stepFunction, Collection<IterationListener> iterationListeners, Model model) {
        this(conf, stepFunction, iterationListeners, Arrays.asList(new ZeroDirection(), new EpsTermination()), model);
    }

    public BaseOptimizer(NeuralNetConfiguration conf, StepFunction stepFunction, Collection<IterationListener> iterationListeners, Collection<TerminationCondition> terminationConditions, Model model) {
        this.conf = conf;
        this.stepFunction = stepFunction != null ? stepFunction : BaseOptimizer.getDefaultStepFunctionForOptimizer(this.getClass());
        this.iterationListeners = iterationListeners != null ? iterationListeners : new ArrayList();
        this.terminationConditions = terminationConditions;
        this.model = model;
        this.lineMaximizer = new BackTrackLineSearch(model, this.stepFunction, this);
        this.lineMaximizer.setStepMax(this.stepMax);
        this.lineMaximizer.setMaxIterations(conf.getMaxNumLineSearchIterations());
    }

    @Override
    public double score() {
        this.model.computeGradientAndScore();
        return this.model.score();
    }

    @Override
    public Updater getUpdater() {
        if (this.updater == null) {
            this.updater = UpdaterCreator.getUpdater(this.model);
        }
        return this.updater;
    }

    @Override
    public void setUpdater(Updater updater) {
        this.updater = updater;
    }

    @Override
    public ComputationGraphUpdater getComputationGraphUpdater() {
        if (this.computationGraphUpdater == null && this.model instanceof ComputationGraph) {
            this.computationGraphUpdater = new ComputationGraphUpdater((ComputationGraph)this.model);
        }
        return this.computationGraphUpdater;
    }

    @Override
    public void setUpdaterComputationGraph(ComputationGraphUpdater updater) {
        this.computationGraphUpdater = updater;
    }

    @Override
    public void setListeners(Collection<IterationListener> listeners) {
        this.iterationListeners = listeners == null ? Collections.emptyList() : listeners;
    }

    @Override
    public NeuralNetConfiguration getConf() {
        return this.conf;
    }

    @Override
    public Pair<Gradient, Double> gradientAndScore() {
        this.oldScore = this.score;
        this.model.computeGradientAndScore();
        Pair<Gradient, Double> pair = this.model.gradientAndScore();
        this.score = pair.getSecond();
        this.updateGradientAccordingToParams(pair.getFirst(), this.model, this.model.batchSize());
        return pair;
    }

    @Override
    public boolean optimize() {
        INDArray parameters = null;
        this.model.validateInput();
        Pair<Gradient, Double> pair = this.gradientAndScore();
        if (this.searchState.isEmpty()) {
            this.searchState.put(GRADIENT_KEY, pair.getFirst().gradient());
            this.setupSearchState(pair);
        } else {
            this.searchState.put(GRADIENT_KEY, pair.getFirst().gradient());
        }
        for (TerminationCondition condition : this.terminationConditions) {
            if (!condition.terminate(0.0, 0.0, new Object[]{pair.getFirst().gradient()})) continue;
            log.info("Hit termination condition " + condition.getClass().getName());
            return true;
        }
        this.preProcessLine();
        for (int i = 0; i < this.conf.getNumIterations(); ++i) {
            INDArray gradient = (INDArray)this.searchState.get(GRADIENT_KEY);
            INDArray searchDirection = (INDArray)this.searchState.get(SEARCH_DIR);
            parameters = (INDArray)this.searchState.get(PARAMS_KEY);
            try {
                this.step = this.lineMaximizer.optimize(parameters, gradient, searchDirection);
            }
            catch (InvalidStepException e) {
                log.warn("Invalid step...continuing another iteration: {}", (Object)e.getMessage());
                this.step = 0.0;
            }
            if (this.step != 0.0) {
                this.stepFunction.step(parameters, searchDirection, this.step);
                this.model.setParams(parameters);
            } else {
                log.debug("Step size returned by line search is 0.0.");
            }
            pair = this.gradientAndScore();
            this.postStep(pair.getFirst().gradient());
            for (IterationListener listener : this.iterationListeners) {
                listener.iterationDone(this.model, i);
            }
            this.checkTerminalConditions(pair.getFirst().gradient(), this.oldScore, this.score, i);
            ++this.iteration;
        }
        return true;
    }

    protected void postFirstStep(INDArray gradient) {
    }

    @Override
    public boolean checkTerminalConditions(INDArray gradient, double oldScore, double score, int i) {
        for (TerminationCondition condition : this.terminationConditions) {
            if (!condition.terminate(score, oldScore, new Object[]{gradient})) continue;
            log.debug("Hit termination condition on iteration {}: score={}, oldScore={}, condition={}", new Object[]{i, score, oldScore, condition});
            if (condition instanceof EpsTermination && this.conf.getLayer() != null && this.conf.getLearningRatePolicy() == LearningRatePolicy.Score) {
                this.model.applyLearningRateScoreDecay();
            }
            return true;
        }
        return false;
    }

    @Override
    public int batchSize() {
        return this.batchSize;
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public void preProcessLine() {
    }

    @Override
    public void postStep(INDArray gradient) {
    }

    @Override
    public void updateGradientAccordingToParams(Gradient gradient, Model model, int batchSize) {
        if (model instanceof ComputationGraph) {
            ComputationGraph graph = (ComputationGraph)model;
            if (this.computationGraphUpdater == null) {
                this.computationGraphUpdater = new ComputationGraphUpdater(graph);
            }
            this.computationGraphUpdater.update(graph, gradient, this.iteration, batchSize);
        } else {
            if (this.updater == null) {
                this.updater = UpdaterCreator.getUpdater(model);
            }
            Layer layer = (Layer)model;
            this.updater.update(layer, gradient, this.iteration, batchSize);
        }
    }

    @Override
    public void setupSearchState(Pair<Gradient, Double> pair) {
        INDArray gradient = pair.getFirst().gradient(this.conf.variables());
        INDArray params = this.model.params();
        this.searchState.put(GRADIENT_KEY, gradient);
        this.searchState.put(SCORE_KEY, pair.getSecond());
        this.searchState.put(PARAMS_KEY, params);
    }

    public static StepFunction getDefaultStepFunctionForOptimizer(Class<? extends ConvexOptimizer> optimizerClass) {
        log.debug("Objective function automatically set to minimize. Set stepFunction in neural net configuration to change default settings.");
        if (optimizerClass == StochasticGradientDescent.class) {
            return new NegativeGradientStepFunction();
        }
        return new NegativeDefaultStepFunction();
    }
}

