/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.optimize.listeners;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.optimize.api.IterationListener;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.ops.transforms.Transforms;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParamAndGradientIterationListener
implements IterationListener {
    private static final int MAX_WRITE_FAILURE_MESSAGES = 10;
    private static final Logger logger = LoggerFactory.getLogger(ParamAndGradientIterationListener.class);
    private boolean invoked = false;
    private int iterations;
    private long totalIterationCount = 0L;
    private boolean printMean = true;
    private boolean printHeader = true;
    private boolean printMinMax = true;
    private boolean printMeanAbsValue = true;
    private File file;
    private Path filePath;
    private boolean outputToConsole;
    private boolean outputToFile;
    private boolean outputToLogger;
    private String delimiter = "\t";
    private int writeFailureCount = 0;

    public ParamAndGradientIterationListener() {
        this(1, true, true, true, true, true, false, false, null, "\t");
    }

    public ParamAndGradientIterationListener(int iterations, boolean printHeader, boolean printMean, boolean printMinMax, boolean printMeanAbsValue, boolean outputToConsole, boolean outputToFile, boolean outputToLogger, File file, String delimiter) {
        this.printHeader = printHeader;
        this.printMean = printMean;
        this.printMinMax = printMinMax;
        this.printMeanAbsValue = printMeanAbsValue;
        this.iterations = iterations;
        this.file = file;
        if (this.file != null) {
            this.filePath = file.toPath();
        }
        this.outputToConsole = outputToConsole;
        this.outputToFile = outputToFile;
        this.outputToLogger = outputToLogger;
        this.delimiter = delimiter;
    }

    @Override
    public boolean invoked() {
        return this.invoked;
    }

    @Override
    public void invoke() {
        this.invoked = true;
    }

    @Override
    public void iterationDone(Model model, int iteration) {
        block27: {
            Map<String, INDArray> params;
            ++this.totalIterationCount;
            if (this.totalIterationCount == 1L && this.printHeader) {
                StringBuilder sb;
                block26: {
                    params = model.paramTable();
                    model.conf().getVariables();
                    sb = new StringBuilder();
                    sb.append("n");
                    sb.append(this.delimiter);
                    sb.append("score");
                    for (String string : params.keySet()) {
                        if (this.printMean) {
                            sb.append(this.delimiter).append(string).append("_mean");
                        }
                        if (this.printMinMax) {
                            sb.append(this.delimiter).append(string).append("_min").append(this.delimiter).append(string).append("_max");
                        }
                        if (this.printMeanAbsValue) {
                            sb.append(this.delimiter).append(string).append("_meanAbsValue");
                        }
                        if (this.printMean) {
                            sb.append(this.delimiter).append(string).append("_meanG");
                        }
                        if (this.printMinMax) {
                            sb.append(this.delimiter).append(string).append("_minG").append(this.delimiter).append(string).append("_maxG");
                        }
                        if (!this.printMeanAbsValue) continue;
                        sb.append(this.delimiter).append(string).append("_meanAbsValueG");
                    }
                    sb.append("\n");
                    if (this.outputToFile) {
                        try {
                            Files.write(this.filePath, sb.toString().getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                        }
                        catch (IOException e) {
                            if (this.writeFailureCount++ < 10) {
                                logger.warn("Error writing to file: {}", (Throwable)e);
                            }
                            if (this.writeFailureCount != 10) break block26;
                            logger.warn("Max file write messages displayed. No more failure messages will be printed");
                        }
                    }
                }
                if (this.outputToLogger) {
                    logger.info(sb.toString());
                }
                if (this.outputToConsole) {
                    System.out.println(sb.toString());
                }
            }
            if (this.totalIterationCount % (long)this.iterations != 0L) {
                return;
            }
            params = model.paramTable();
            Map<String, INDArray> grads = model.gradient().gradientForVariable();
            StringBuilder sb = new StringBuilder();
            sb.append(this.totalIterationCount);
            sb.append(this.delimiter);
            sb.append(model.score());
            for (String s : params.keySet()) {
                INDArray abs;
                INDArray currParams = params.get(s);
                INDArray currGrad = grads.get(s);
                if (this.printMean) {
                    sb.append(this.delimiter);
                    sb.append(currParams.meanNumber().doubleValue());
                }
                if (this.printMinMax) {
                    sb.append(this.delimiter);
                    sb.append(currParams.minNumber().doubleValue());
                    sb.append(this.delimiter);
                    sb.append(currParams.maxNumber().doubleValue());
                }
                if (this.printMeanAbsValue) {
                    sb.append(this.delimiter);
                    abs = Transforms.abs((INDArray)currParams.dup());
                    sb.append(abs.meanNumber().doubleValue());
                }
                if (this.printMean) {
                    sb.append(this.delimiter);
                    sb.append(currGrad.meanNumber().doubleValue());
                }
                if (this.printMinMax) {
                    sb.append(this.delimiter);
                    sb.append(currGrad.minNumber().doubleValue());
                    sb.append(this.delimiter);
                    sb.append(currGrad.maxNumber().doubleValue());
                }
                if (!this.printMeanAbsValue) continue;
                sb.append(this.delimiter);
                abs = Transforms.abs((INDArray)currGrad.dup());
                sb.append(abs.meanNumber().doubleValue());
            }
            sb.append("\n");
            String string = sb.toString();
            if (this.outputToLogger) {
                logger.info(string);
            }
            if (this.outputToConsole) {
                System.out.print(string);
            }
            if (this.outputToFile) {
                try {
                    Files.write(this.filePath, string.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                }
                catch (IOException e) {
                    if (this.writeFailureCount++ < 10) {
                        logger.warn("Error writing to file: {}", (Throwable)e);
                    }
                    if (this.writeFailureCount != 10) break block27;
                    logger.warn("Max file write messages displayed. No more failure messages will be printed");
                }
            }
        }
    }

    public static ParamAndGradientIterationListenerBuilder builder() {
        return new ParamAndGradientIterationListenerBuilder();
    }

    public static class ParamAndGradientIterationListenerBuilder {
        private int iterations;
        private boolean printHeader;
        private boolean printMean;
        private boolean printMinMax;
        private boolean printMeanAbsValue;
        private boolean outputToConsole;
        private boolean outputToFile;
        private boolean outputToLogger;
        private File file;
        private String delimiter;

        ParamAndGradientIterationListenerBuilder() {
        }

        public ParamAndGradientIterationListenerBuilder iterations(int iterations) {
            this.iterations = iterations;
            return this;
        }

        public ParamAndGradientIterationListenerBuilder printHeader(boolean printHeader) {
            this.printHeader = printHeader;
            return this;
        }

        public ParamAndGradientIterationListenerBuilder printMean(boolean printMean) {
            this.printMean = printMean;
            return this;
        }

        public ParamAndGradientIterationListenerBuilder printMinMax(boolean printMinMax) {
            this.printMinMax = printMinMax;
            return this;
        }

        public ParamAndGradientIterationListenerBuilder printMeanAbsValue(boolean printMeanAbsValue) {
            this.printMeanAbsValue = printMeanAbsValue;
            return this;
        }

        public ParamAndGradientIterationListenerBuilder outputToConsole(boolean outputToConsole) {
            this.outputToConsole = outputToConsole;
            return this;
        }

        public ParamAndGradientIterationListenerBuilder outputToFile(boolean outputToFile) {
            this.outputToFile = outputToFile;
            return this;
        }

        public ParamAndGradientIterationListenerBuilder outputToLogger(boolean outputToLogger) {
            this.outputToLogger = outputToLogger;
            return this;
        }

        public ParamAndGradientIterationListenerBuilder file(File file) {
            this.file = file;
            return this;
        }

        public ParamAndGradientIterationListenerBuilder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public ParamAndGradientIterationListener build() {
            return new ParamAndGradientIterationListener(this.iterations, this.printHeader, this.printMean, this.printMinMax, this.printMeanAbsValue, this.outputToConsole, this.outputToFile, this.outputToLogger, this.file, this.delimiter);
        }

        public String toString() {
            return "ParamAndGradientIterationListener.ParamAndGradientIterationListenerBuilder(iterations=" + this.iterations + ", printHeader=" + this.printHeader + ", printMean=" + this.printMean + ", printMinMax=" + this.printMinMax + ", printMeanAbsValue=" + this.printMeanAbsValue + ", outputToConsole=" + this.outputToConsole + ", outputToFile=" + this.outputToFile + ", outputToLogger=" + this.outputToLogger + ", file=" + this.file + ", delimiter=" + this.delimiter + ")";
        }
    }
}

