/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.params;

import java.util.Map;
import org.canova.api.conf.Configuration;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.BatchNormalization;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class BatchNormalizationParamInitializer
implements ParamInitializer {
    public static final String GAMMA = "gamma";
    public static final String BETA = "beta";

    @Override
    public void init(Map<String, INDArray> params, NeuralNetConfiguration conf) {
        params.put(GAMMA, this.createGamma(conf));
        conf.addVariable(GAMMA);
        params.put(BETA, this.createBeta(conf));
        conf.addVariable(BETA);
    }

    @Override
    public void init(Map<String, INDArray> params, NeuralNetConfiguration conf, Configuration extraConf) {
        this.init(params, conf);
    }

    protected INDArray createBeta(NeuralNetConfiguration conf) {
        BatchNormalization layer = (BatchNormalization)conf.getLayer();
        INDArray ret = Nd4j.valueArrayOf((int)layer.getNOut(), (double)layer.getBeta());
        ret.data().persist();
        return ret;
    }

    protected INDArray createGamma(NeuralNetConfiguration conf) {
        BatchNormalization layer = (BatchNormalization)conf.getLayer();
        INDArray ret = Nd4j.valueArrayOf((int)layer.getNOut(), (double)layer.getGamma());
        ret.data().persist();
        return ret;
    }
}

