/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.recurrent;

import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.recurrent.BaseRecurrentLayer;
import org.deeplearning4j.nn.layers.recurrent.FwdPassReturn;
import org.deeplearning4j.nn.layers.recurrent.LSTMHelpers;
import org.nd4j.linalg.api.ndarray.INDArray;

public class GravesLSTM
extends BaseRecurrentLayer<org.deeplearning4j.nn.conf.layers.GravesLSTM> {
    public static final String STATE_KEY_PREV_ACTIVATION = "prevAct";
    public static final String STATE_KEY_PREV_MEMCELL = "prevMem";

    public GravesLSTM(NeuralNetConfiguration conf) {
        super(conf);
    }

    public GravesLSTM(NeuralNetConfiguration conf, INDArray input) {
        super(conf, input);
    }

    @Override
    public Gradient gradient() {
        throw new UnsupportedOperationException("gradient() method for layerwise pretraining: not supported for LSTMs (pretraining not possible)");
    }

    @Override
    public Gradient calcGradient(Gradient layerError, INDArray activation) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon) {
        return this.backpropGradientHelper(epsilon, false, -1);
    }

    @Override
    public Pair<Gradient, INDArray> tbpttBackpropGradient(INDArray epsilon, int tbpttBackwardLength) {
        return this.backpropGradientHelper(epsilon, true, tbpttBackwardLength);
    }

    private Pair<Gradient, INDArray> backpropGradientHelper(INDArray epsilon, boolean truncatedBPTT, int tbpttBackwardLength) {
        FwdPassReturn fwdPass;
        INDArray inputWeights = this.getParam("W");
        INDArray recurrentWeights = this.getParam("RW");
        if (truncatedBPTT) {
            fwdPass = this.activateHelper(true, (INDArray)this.stateMap.get(STATE_KEY_PREV_ACTIVATION), (INDArray)this.stateMap.get(STATE_KEY_PREV_MEMCELL), true);
            this.tBpttStateMap.put(STATE_KEY_PREV_ACTIVATION, fwdPass.lastAct);
            this.tBpttStateMap.put(STATE_KEY_PREV_MEMCELL, fwdPass.lastMemCell);
        } else {
            fwdPass = this.activateHelper(true, null, null, true);
        }
        return LSTMHelpers.backpropGradientHelper(this.conf, this.input, recurrentWeights, inputWeights, epsilon, truncatedBPTT, tbpttBackwardLength, fwdPass, true, "W", "RW", "b");
    }

    @Override
    public INDArray preOutput(INDArray x) {
        return this.activate(x, true);
    }

    @Override
    public INDArray preOutput(INDArray x, boolean training) {
        return this.activate(x, training);
    }

    @Override
    public INDArray activate(INDArray input, boolean training) {
        this.setInput(input);
        return this.activateHelper((boolean)training, null, null, (boolean)false).fwdPassOutput;
    }

    @Override
    public INDArray activate(INDArray input) {
        this.setInput(input);
        return this.activateHelper((boolean)true, null, null, (boolean)false).fwdPassOutput;
    }

    @Override
    public INDArray activate(boolean training) {
        return this.activateHelper((boolean)training, null, null, (boolean)false).fwdPassOutput;
    }

    @Override
    public INDArray activate() {
        return this.activateHelper((boolean)false, null, null, (boolean)false).fwdPassOutput;
    }

    private FwdPassReturn activateHelper(boolean training, INDArray prevOutputActivations, INDArray prevMemCellState, boolean forBackprop) {
        INDArray recurrentWeights = this.getParam("RW");
        INDArray inputWeights = this.getParam("W");
        INDArray biases = this.getParam("b");
        return LSTMHelpers.activateHelper(this, this.conf, this.input, recurrentWeights, inputWeights, biases, training, prevOutputActivations, prevMemCellState, forBackprop, true, "W");
    }

    @Override
    public INDArray activationMean() {
        return this.activate();
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.RECURRENT;
    }

    @Override
    public Layer transpose() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public double calcL2() {
        if (!this.conf.isUseRegularization() || this.conf.getLayer().getL2() <= 0.0) {
            return 0.0;
        }
        double l2Norm = this.getParam("RW").norm2Number().doubleValue();
        double sumSquaredWeights = l2Norm * l2Norm;
        l2Norm = this.getParam("W").norm2Number().doubleValue();
        return 0.5 * this.conf.getLayer().getL2() * (sumSquaredWeights += l2Norm * l2Norm);
    }

    @Override
    public double calcL1() {
        if (!this.conf.isUseRegularization() || this.conf.getLayer().getL1() <= 0.0) {
            return 0.0;
        }
        double l1 = this.getParam("RW").norm1Number().doubleValue() + this.getParam("W").norm1Number().doubleValue();
        return this.conf.getLayer().getL1() * l1;
    }

    @Override
    public INDArray rnnTimeStep(INDArray input) {
        this.setInput(input);
        FwdPassReturn fwdPass = this.activateHelper(false, (INDArray)this.stateMap.get(STATE_KEY_PREV_ACTIVATION), (INDArray)this.stateMap.get(STATE_KEY_PREV_MEMCELL), false);
        INDArray outAct = fwdPass.fwdPassOutput;
        this.stateMap.put(STATE_KEY_PREV_ACTIVATION, fwdPass.lastAct);
        this.stateMap.put(STATE_KEY_PREV_MEMCELL, fwdPass.lastMemCell);
        return outAct;
    }

    @Override
    public INDArray rnnActivateUsingStoredState(INDArray input, boolean training, boolean storeLastForTBPTT) {
        this.setInput(input);
        FwdPassReturn fwdPass = this.activateHelper(training, (INDArray)this.stateMap.get(STATE_KEY_PREV_ACTIVATION), (INDArray)this.stateMap.get(STATE_KEY_PREV_MEMCELL), false);
        INDArray outAct = fwdPass.fwdPassOutput;
        if (storeLastForTBPTT) {
            this.tBpttStateMap.put(STATE_KEY_PREV_ACTIVATION, fwdPass.lastAct);
            this.tBpttStateMap.put(STATE_KEY_PREV_MEMCELL, fwdPass.lastMemCell);
        }
        return outAct;
    }
}

