/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.feedforward.autoencoder;

import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.layers.BasePretrainNetwork;
import org.deeplearning4j.util.Dropout;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class AutoEncoder
extends BasePretrainNetwork<org.deeplearning4j.nn.conf.layers.AutoEncoder> {
    private static final long serialVersionUID = -6445530486350763837L;

    public AutoEncoder(NeuralNetConfiguration conf) {
        super(conf);
    }

    public AutoEncoder(NeuralNetConfiguration conf, INDArray input) {
        super(conf, input);
    }

    @Override
    public Pair<INDArray, INDArray> sampleHiddenGivenVisible(INDArray v) {
        this.setInput(v);
        INDArray ret = this.encode(true);
        return new Pair<INDArray, INDArray>(ret, ret);
    }

    @Override
    public Pair<INDArray, INDArray> sampleVisibleGivenHidden(INDArray h) {
        INDArray ret = this.decode(h);
        return new Pair<INDArray, INDArray>(ret, ret);
    }

    public INDArray encode(boolean training) {
        if (this.conf.getLayer().getDropOut() > 0.0 && training) {
            this.dropoutMask = Dropout.applyDropout(this.input, this.conf.getLayer().getDropOut(), this.dropoutMask);
        }
        INDArray W = this.getParam("W");
        INDArray hBias = this.getParam("b");
        INDArray preAct = this.input.mmul(W).addiRowVector(hBias);
        INDArray ret = Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createTransform(this.conf.getLayer().getActivationFunction(), preAct));
        return ret;
    }

    public INDArray decode(INDArray y) {
        INDArray W = this.getParam("W");
        INDArray vBias = this.getParam("bB");
        INDArray preAct = y.mmul(W.transposei());
        preAct.addiRowVector(vBias);
        return Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createTransform(this.conf.getLayer().getActivationFunction(), preAct));
    }

    @Override
    public INDArray activate(INDArray input, boolean training) {
        this.setInput(input);
        return this.encode(training);
    }

    @Override
    public INDArray activate(INDArray input) {
        this.setInput(input);
        return this.encode(true);
    }

    @Override
    public INDArray activate(boolean training) {
        return this.decode(this.encode(training));
    }

    @Override
    public INDArray activate() {
        return this.decode(this.encode(false));
    }

    @Override
    public void computeGradientAndScore() {
        INDArray W = this.getParam("W");
        double corruptionLevel = ((org.deeplearning4j.nn.conf.layers.AutoEncoder)this.layerConf()).getCorruptionLevel();
        INDArray corruptedX = corruptionLevel > 0.0 ? this.getCorruptedInput(this.input, corruptionLevel) : this.input;
        this.setInput(corruptedX);
        INDArray y = this.encode(true);
        INDArray z = this.decode(y);
        INDArray visibleLoss = this.input.sub(z);
        INDArray hiddenLoss = ((org.deeplearning4j.nn.conf.layers.AutoEncoder)this.layerConf()).getSparsity() == 0.0 ? visibleLoss.mmul(W).muli(y).muli(y.rsub((Number)1)) : visibleLoss.mmul(W).muli(y).muli(y.add((Number)(-((org.deeplearning4j.nn.conf.layers.AutoEncoder)this.layerConf()).getSparsity())));
        INDArray wGradient = corruptedX.transposei().mmul(hiddenLoss).addi(visibleLoss.transposei().mmul(y));
        INDArray hBiasGradient = hiddenLoss.sum(new int[]{0});
        INDArray vBiasGradient = visibleLoss.sum(new int[]{0});
        this.gradient = this.createGradient(wGradient, vBiasGradient, hBiasGradient);
        this.setScoreWithZ(z);
    }
}

