/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution.subsampling;

import java.util.Arrays;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.SubsamplingLayer;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.BaseLayer;
import org.deeplearning4j.util.Dropout;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.TransformOp;
import org.nd4j.linalg.api.ops.impl.transforms.IsMax;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.convolution.Convolution;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.ArrayUtil;

public class SubsamplingLayer
extends BaseLayer<org.deeplearning4j.nn.conf.layers.SubsamplingLayer> {
    private INDArray maxIndexes;

    public SubsamplingLayer(NeuralNetConfiguration conf) {
        super(conf);
    }

    public SubsamplingLayer(NeuralNetConfiguration conf, INDArray input) {
        super(conf, input);
    }

    @Override
    public double calcL2() {
        return 0.0;
    }

    @Override
    public double calcL1() {
        return 0.0;
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.SUBSAMPLING;
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon) {
        INDArray epsilon1d;
        INDArray col6dPermuted;
        INDArray col6d;
        int miniBatch = this.input.size(0);
        int depth = this.input.size(1);
        int inH = this.input.size(2);
        int inW = this.input.size(3);
        int[] kernel = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getKernelSize();
        int[] strides = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getStride();
        int[] pad = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPadding();
        int outH = Convolution.outSize((int)inH, (int)kernel[0], (int)strides[0], (int)pad[0], (boolean)false);
        int outW = Convolution.outSize((int)inW, (int)kernel[1], (int)strides[1], (int)pad[1], (boolean)false);
        int inputHeight = this.input().size(-2);
        int inputWidth = this.input().size(-1);
        DefaultGradient retGradient = new DefaultGradient();
        boolean cOrderStrides = false;
        if (epsilon.ordering() != 'c') {
            epsilon = epsilon.dup('c');
            cOrderStrides = true;
        }
        if (!cOrderStrides && Shape.strideDescendingCAscendingF((INDArray)epsilon)) {
            cOrderStrides = true;
        } else if (!Arrays.equals(new int[]{outH * outW, depth * outH * outW, outW, 1}, epsilon.stride())) {
            epsilon = epsilon.dup('c');
            cOrderStrides = true;
        }
        if (cOrderStrides) {
            col6d = Nd4j.create((int[])new int[]{miniBatch, depth, outH, outW, kernel[0], kernel[1]}, (char)'c');
            col6dPermuted = col6d.permute(new int[]{0, 1, 4, 5, 2, 3});
            epsilon1d = epsilon.reshape('c', ArrayUtil.prod((int[])new int[]{epsilon.length()}), 1);
        } else {
            col6d = Nd4j.create((int[])new int[]{depth, miniBatch, outH, outW, kernel[0], kernel[1]}, (char)'c');
            col6dPermuted = col6d.permute(new int[]{1, 0, 4, 5, 2, 3});
            INDArray epsilonTemp = epsilon.permute(new int[]{1, 0, 2, 3});
            epsilon1d = epsilonTemp.reshape('c', new int[]{ArrayUtil.prod((int[])new int[]{epsilon.length()}), 1});
        }
        INDArray col2d = col6d.reshape('c', miniBatch * depth * outH * outW, kernel[0] * kernel[1]);
        switch (((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPoolingType()) {
            case MAX: {
                Convolution.im2col((INDArray)this.input, (int)kernel[0], (int)kernel[1], (int)strides[0], (int)strides[1], (int)pad[0], (int)pad[1], (boolean)false, (INDArray)col6dPermuted);
                INDArray isMax = Nd4j.getExecutioner().execAndReturn((TransformOp)new IsMax(col2d, new int[]{1}));
                isMax.muliColumnVector(epsilon1d);
                break;
            }
            case AVG: {
                col2d.addiRowVector(epsilon1d);
                break;
            }
            case NONE: {
                return new Pair<Gradient, INDArray>(retGradient, epsilon);
            }
            default: {
                throw new IllegalStateException("Unsupported pooling type");
            }
        }
        INDArray tempEpsilon = Nd4j.create((int[])new int[]{depth, miniBatch, inH, inW}, (char)'c');
        INDArray outEpsilon = tempEpsilon.permute(new int[]{1, 0, 2, 3});
        Convolution.col2im((INDArray)col6dPermuted, (INDArray)outEpsilon, (int)strides[0], (int)strides[1], (int)pad[0], (int)pad[1], (int)inputHeight, (int)inputWidth);
        if (((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPoolingType() == SubsamplingLayer.PoolingType.AVG) {
            outEpsilon.divi((Number)ArrayUtil.prod((int[])((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getKernelSize()));
        }
        return new Pair<Gradient, INDArray>(retGradient, outEpsilon);
    }

    @Override
    public INDArray activate(boolean training) {
        INDArray reduced;
        if (training && this.conf.getLayer().getDropOut() > 0.0) {
            this.dropoutMask = Dropout.applyDropout(this.input, this.conf.getLayer().getDropOut(), this.dropoutMask);
        }
        int miniBatch = this.input.size(0);
        int inDepth = this.input.size(1);
        int inH = this.input.size(2);
        int inW = this.input.size(3);
        int[] kernel = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getKernelSize();
        int[] strides = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getStride();
        int[] pad = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPadding();
        int outH = Convolution.outSize((int)inH, (int)kernel[0], (int)strides[0], (int)pad[0], (boolean)false);
        int outW = Convolution.outSize((int)inW, (int)kernel[1], (int)strides[1], (int)pad[1], (boolean)false);
        INDArray col = Nd4j.create((int[])new int[]{miniBatch, inDepth, outH, outW, kernel[0], kernel[1]}, (char)'c');
        INDArray col2 = col.permute(new int[]{0, 1, 4, 5, 2, 3});
        Convolution.im2col((INDArray)this.input, (int)kernel[0], (int)kernel[1], (int)strides[0], (int)strides[1], (int)pad[0], (int)pad[1], (boolean)false, (INDArray)col2);
        INDArray col2d = col.reshape('c', miniBatch * inDepth * outH * outW, kernel[0] * kernel[1]);
        switch (((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPoolingType()) {
            case AVG: {
                reduced = col2d.mean(new int[]{1});
                break;
            }
            case MAX: {
                reduced = col2d.max(new int[]{1});
                break;
            }
            case NONE: {
                return this.input;
            }
            default: {
                throw new IllegalStateException("Unknown/not supported pooling type: " + (Object)((Object)((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPoolingType()));
            }
        }
        return reduced.reshape('c', new int[]{miniBatch, inDepth, outH, outW});
    }

    @Override
    public Gradient error(INDArray input) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Gradient calcGradient(Gradient layerError, INDArray indArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void merge(Layer layer, int batchSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray activationMean() {
        return null;
    }

    @Override
    public Layer transpose() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void iterate(INDArray input) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void fit() {
    }

    @Override
    public int numParams() {
        return 0;
    }

    @Override
    public void fit(INDArray input) {
    }

    @Override
    public void computeGradientAndScore() {
    }

    @Override
    public double score() {
        return 0.0;
    }

    @Override
    public void accumulateScore(double accum) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void update(INDArray gradient, String paramType) {
    }

    @Override
    public INDArray params() {
        return null;
    }

    @Override
    public INDArray getParam(String param) {
        return this.params();
    }

    @Override
    public void setParams(INDArray params) {
    }
}

