/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.iterator;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.List;
import org.deeplearning4j.datasets.iterator.DataSetIterator;
import org.deeplearning4j.datasets.iterator.DataSetPreProcessor;
import org.nd4j.linalg.dataset.api.DataSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleEpochsIterator
implements DataSetIterator {
    @VisibleForTesting
    protected int numPasses;
    protected int batch = 0;
    protected DataSetIterator iter;
    protected org.nd4j.linalg.dataset.DataSet ds;
    protected List<org.nd4j.linalg.dataset.DataSet> batchedDS = Lists.newArrayList();
    protected int passes = 0;
    protected static final Logger log = LoggerFactory.getLogger(MultipleEpochsIterator.class);
    protected DataSetPreProcessor preProcessor;

    public MultipleEpochsIterator(int numPasses, DataSetIterator iter) {
        this.numPasses = numPasses;
        this.iter = iter;
    }

    public MultipleEpochsIterator(int numPasses, org.nd4j.linalg.dataset.DataSet ds) {
        this.numPasses = numPasses;
        this.ds = ds;
    }

    public org.nd4j.linalg.dataset.DataSet next(int num) {
        org.nd4j.linalg.dataset.DataSet next;
        if (this.iter == null) {
            if (num == -1) {
                if (this.passes < this.numPasses) {
                    this.trackEpoch();
                }
                next = this.ds;
            } else {
                if (this.batchedDS.isEmpty() && num > 0) {
                    this.batchedDS = this.ds.batchBy(num);
                }
                next = this.batchedDS.get(this.batch);
                if (this.batch + 1 == this.batchedDS.size()) {
                    this.trackEpoch();
                    if (this.passes < this.numPasses) {
                        this.batch = -1;
                    }
                }
            }
        } else {
            if (!this.iter.hasNext()) {
                this.trackEpoch();
                if (this.passes < this.numPasses) {
                    this.iter.reset();
                    this.batch = 0;
                }
            }
            org.nd4j.linalg.dataset.DataSet dataSet = next = num == -1 ? (org.nd4j.linalg.dataset.DataSet)this.iter.next() : this.iter.next(num);
            if (this.preProcessor != null) {
                this.preProcessor.preProcess((DataSet)next);
            }
        }
        ++this.batch;
        return next;
    }

    private void trackEpoch() {
        ++this.passes;
        log.info("Epoch " + this.passes + ", number of batches completed " + this.batch);
    }

    @Override
    public org.nd4j.linalg.dataset.DataSet next() {
        return this.next(-1);
    }

    public int totalExamples() {
        return this.iter.totalExamples();
    }

    public int inputColumns() {
        return this.iter.inputColumns();
    }

    public int totalOutcomes() {
        return this.iter.totalOutcomes();
    }

    public void reset() {
        this.passes = 0;
        this.batch = 0;
        this.iter.reset();
    }

    public int batch() {
        return this.iter.batch();
    }

    public int cursor() {
        return this.iter.cursor();
    }

    public int numExamples() {
        return this.iter.numExamples();
    }

    public void setPreProcessor(org.nd4j.linalg.dataset.api.DataSetPreProcessor preProcessor) {
        this.preProcessor = (DataSetPreProcessor)preProcessor;
    }

    public List<String> getLabels() {
        return this.iter.getLabels();
    }

    @Override
    public boolean hasNext() {
        if (this.iter == null) {
            return this.passes < this.numPasses && (this.batchedDS.size() != 0 && this.batchedDS.size() > this.batch || this.batchedDS.size() == 0);
        }
        return this.passes + 1 < this.numPasses || this.iter.hasNext() && this.passes == 0;
    }

    @Override
    public void remove() {
        this.iter.remove();
    }
}

