/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.iterator;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import org.deeplearning4j.datasets.iterator.DataSetIterator;
import org.deeplearning4j.datasets.iterator.DataSetPreProcessor;
import org.nd4j.linalg.dataset.api.DataSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleEpochsIterator
implements DataSetIterator {
    @VisibleForTesting
    protected int numPasses;
    protected int batch = 0;
    protected DataSetIterator iter;
    protected int passes = 0;
    protected static final Logger log = LoggerFactory.getLogger(MultipleEpochsIterator.class);
    protected DataSetPreProcessor preProcessor;

    public MultipleEpochsIterator(int numPasses, DataSetIterator iter) {
        this.numPasses = numPasses;
        this.iter = iter;
    }

    public org.nd4j.linalg.dataset.DataSet next(int num) {
        if (!this.iter.hasNext()) {
            log.info("Epoch " + this.passes + ", number of batches completed " + this.batch);
            if (this.passes < this.numPasses) {
                ++this.passes;
                this.batch = 0;
                this.iter.reset();
            }
        }
        ++this.batch;
        org.nd4j.linalg.dataset.DataSet next = this.iter.next(num);
        if (this.preProcessor != null) {
            this.preProcessor.preProcess((DataSet)next);
        }
        return next;
    }

    public int totalExamples() {
        return this.iter.totalExamples();
    }

    public int inputColumns() {
        return this.iter.inputColumns();
    }

    public int totalOutcomes() {
        return this.iter.totalOutcomes();
    }

    public void reset() {
        this.passes = 0;
        this.batch = 0;
        this.iter.reset();
    }

    public int batch() {
        return this.iter.batch();
    }

    public int cursor() {
        return this.iter.cursor();
    }

    public int numExamples() {
        return this.iter.numExamples();
    }

    public void setPreProcessor(org.nd4j.linalg.dataset.api.DataSetPreProcessor preProcessor) {
        this.preProcessor = (DataSetPreProcessor)preProcessor;
    }

    public List<String> getLabels() {
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext() || this.passes < this.numPasses;
    }

    @Override
    public org.nd4j.linalg.dataset.DataSet next() {
        if (!this.iter.hasNext()) {
            log.info("Epoch " + this.passes + " batch " + this.batch);
            if (this.passes < this.numPasses) {
                ++this.passes;
                this.batch = 0;
                this.iter.reset();
            }
        }
        ++this.batch;
        org.nd4j.linalg.dataset.DataSet next = (org.nd4j.linalg.dataset.DataSet)this.iter.next();
        if (this.preProcessor != null) {
            this.preProcessor.preProcess((DataSet)next);
        }
        return next;
    }

    @Override
    public void remove() {
        this.iter.remove();
    }
}

