/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.nn.api.OptimizationAlgorithm;
import org.deeplearning4j.nn.conf.GradientNormalization;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.conf.Updater;
import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.deeplearning4j.nn.conf.distribution.NormalDistribution;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.stepfunctions.StepFunction;
import org.deeplearning4j.nn.weights.WeightInit;
import org.nd4j.linalg.factory.Nd4j;

public class NeuralNetConfiguration
implements Serializable,
Cloneable {
    protected Layer layer;
    protected boolean miniBatch = true;
    protected int numIterations = 5;
    protected int maxNumLineSearchIterations = 5;
    protected long seed = System.currentTimeMillis();
    protected OptimizationAlgorithm optimizationAlgo = OptimizationAlgorithm.CONJUGATE_GRADIENT;
    protected List<String> variables = new ArrayList<String>();
    protected StepFunction stepFunction;
    protected boolean useRegularization = false;
    protected boolean useDropConnect = false;
    protected boolean useSchedules = false;
    protected boolean minimize = true;
    @Deprecated
    private int timeSeriesLength = 1;
    private static final ObjectMapper mapperYaml = NeuralNetConfiguration.initMapperYaml();
    private static final ObjectMapper mapper = NeuralNetConfiguration.initMapper();

    public NeuralNetConfiguration clone() {
        try {
            NeuralNetConfiguration clone = (NeuralNetConfiguration)super.clone();
            if (clone.layer != null) {
                clone.layer = clone.layer.clone();
            }
            if (clone.stepFunction != null) {
                clone.stepFunction = clone.stepFunction.clone();
            }
            if (clone.variables != null) {
                clone.variables = new ArrayList<String>(clone.variables);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> variables() {
        return new ArrayList<String>(this.variables);
    }

    public void addVariable(String variable) {
        if (!this.variables.contains(variable)) {
            this.variables.add(variable);
        }
    }

    public void clearVariables() {
        this.variables.clear();
    }

    public String toYaml() {
        ObjectMapper mapper = NeuralNetConfiguration.mapperYaml();
        try {
            String ret = mapper.writeValueAsString((Object)this);
            return ret;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static NeuralNetConfiguration fromYaml(String json) {
        ObjectMapper mapper = NeuralNetConfiguration.mapperYaml();
        try {
            NeuralNetConfiguration ret = (NeuralNetConfiguration)mapper.readValue(json, NeuralNetConfiguration.class);
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toJson() {
        ObjectMapper mapper = NeuralNetConfiguration.mapper();
        try {
            String ret = mapper.writeValueAsString((Object)this);
            return ret;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static NeuralNetConfiguration fromJson(String json) {
        ObjectMapper mapper = NeuralNetConfiguration.mapper();
        try {
            NeuralNetConfiguration ret = (NeuralNetConfiguration)mapper.readValue(json, NeuralNetConfiguration.class);
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ObjectMapper mapperYaml() {
        return mapperYaml;
    }

    private static ObjectMapper initMapperYaml() {
        ObjectMapper ret = new ObjectMapper((JsonFactory)new YAMLFactory());
        ret.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        ret.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        ret.enable(SerializationFeature.INDENT_OUTPUT);
        return ret;
    }

    public static ObjectMapper mapper() {
        return mapper;
    }

    private static ObjectMapper initMapper() {
        ObjectMapper ret = new ObjectMapper();
        ret.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        ret.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        ret.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        ret.enable(SerializationFeature.INDENT_OUTPUT);
        return ret;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public boolean isMiniBatch() {
        return this.miniBatch;
    }

    public int getNumIterations() {
        return this.numIterations;
    }

    public int getMaxNumLineSearchIterations() {
        return this.maxNumLineSearchIterations;
    }

    public long getSeed() {
        return this.seed;
    }

    public OptimizationAlgorithm getOptimizationAlgo() {
        return this.optimizationAlgo;
    }

    public List<String> getVariables() {
        return this.variables;
    }

    public StepFunction getStepFunction() {
        return this.stepFunction;
    }

    public boolean isUseRegularization() {
        return this.useRegularization;
    }

    public boolean isUseDropConnect() {
        return this.useDropConnect;
    }

    public boolean isUseSchedules() {
        return this.useSchedules;
    }

    public boolean isMinimize() {
        return this.minimize;
    }

    @Deprecated
    public int getTimeSeriesLength() {
        return this.timeSeriesLength;
    }

    public void setLayer(Layer layer) {
        this.layer = layer;
    }

    public void setMiniBatch(boolean miniBatch) {
        this.miniBatch = miniBatch;
    }

    public void setNumIterations(int numIterations) {
        this.numIterations = numIterations;
    }

    public void setMaxNumLineSearchIterations(int maxNumLineSearchIterations) {
        this.maxNumLineSearchIterations = maxNumLineSearchIterations;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public void setOptimizationAlgo(OptimizationAlgorithm optimizationAlgo) {
        this.optimizationAlgo = optimizationAlgo;
    }

    public void setVariables(List<String> variables) {
        this.variables = variables;
    }

    public void setStepFunction(StepFunction stepFunction) {
        this.stepFunction = stepFunction;
    }

    public void setUseRegularization(boolean useRegularization) {
        this.useRegularization = useRegularization;
    }

    public void setUseDropConnect(boolean useDropConnect) {
        this.useDropConnect = useDropConnect;
    }

    public void setUseSchedules(boolean useSchedules) {
        this.useSchedules = useSchedules;
    }

    public void setMinimize(boolean minimize) {
        this.minimize = minimize;
    }

    @Deprecated
    public void setTimeSeriesLength(int timeSeriesLength) {
        this.timeSeriesLength = timeSeriesLength;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NeuralNetConfiguration)) {
            return false;
        }
        NeuralNetConfiguration other = (NeuralNetConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Layer this$layer = this.getLayer();
        Layer other$layer = other.getLayer();
        if (this$layer == null ? other$layer != null : !((Object)this$layer).equals(other$layer)) {
            return false;
        }
        if (this.isMiniBatch() != other.isMiniBatch()) {
            return false;
        }
        if (this.getNumIterations() != other.getNumIterations()) {
            return false;
        }
        if (this.getMaxNumLineSearchIterations() != other.getMaxNumLineSearchIterations()) {
            return false;
        }
        if (this.getSeed() != other.getSeed()) {
            return false;
        }
        OptimizationAlgorithm this$optimizationAlgo = this.getOptimizationAlgo();
        OptimizationAlgorithm other$optimizationAlgo = other.getOptimizationAlgo();
        if (this$optimizationAlgo == null ? other$optimizationAlgo != null : !((Object)((Object)this$optimizationAlgo)).equals((Object)other$optimizationAlgo)) {
            return false;
        }
        List<String> this$variables = this.getVariables();
        List<String> other$variables = other.getVariables();
        if (this$variables == null ? other$variables != null : !((Object)this$variables).equals(other$variables)) {
            return false;
        }
        StepFunction this$stepFunction = this.getStepFunction();
        StepFunction other$stepFunction = other.getStepFunction();
        if (this$stepFunction == null ? other$stepFunction != null : !this$stepFunction.equals(other$stepFunction)) {
            return false;
        }
        if (this.isUseRegularization() != other.isUseRegularization()) {
            return false;
        }
        if (this.isUseDropConnect() != other.isUseDropConnect()) {
            return false;
        }
        if (this.isUseSchedules() != other.isUseSchedules()) {
            return false;
        }
        if (this.isMinimize() != other.isMinimize()) {
            return false;
        }
        return this.getTimeSeriesLength() == other.getTimeSeriesLength();
    }

    protected boolean canEqual(Object other) {
        return other instanceof NeuralNetConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Layer $layer = this.getLayer();
        result = result * 59 + ($layer == null ? 0 : ((Object)$layer).hashCode());
        result = result * 59 + (this.isMiniBatch() ? 79 : 97);
        result = result * 59 + this.getNumIterations();
        result = result * 59 + this.getMaxNumLineSearchIterations();
        long $seed = this.getSeed();
        result = result * 59 + (int)($seed >>> 32 ^ $seed);
        OptimizationAlgorithm $optimizationAlgo = this.getOptimizationAlgo();
        result = result * 59 + ($optimizationAlgo == null ? 0 : ((Object)((Object)$optimizationAlgo)).hashCode());
        List<String> $variables = this.getVariables();
        result = result * 59 + ($variables == null ? 0 : ((Object)$variables).hashCode());
        StepFunction $stepFunction = this.getStepFunction();
        result = result * 59 + ($stepFunction == null ? 0 : $stepFunction.hashCode());
        result = result * 59 + (this.isUseRegularization() ? 79 : 97);
        result = result * 59 + (this.isUseDropConnect() ? 79 : 97);
        result = result * 59 + (this.isUseSchedules() ? 79 : 97);
        result = result * 59 + (this.isMinimize() ? 79 : 97);
        result = result * 59 + this.getTimeSeriesLength();
        return result;
    }

    public String toString() {
        return "NeuralNetConfiguration(layer=" + this.getLayer() + ", miniBatch=" + this.isMiniBatch() + ", numIterations=" + this.getNumIterations() + ", maxNumLineSearchIterations=" + this.getMaxNumLineSearchIterations() + ", seed=" + this.getSeed() + ", optimizationAlgo=" + (Object)((Object)this.getOptimizationAlgo()) + ", variables=" + this.getVariables() + ", stepFunction=" + this.getStepFunction() + ", useRegularization=" + this.isUseRegularization() + ", useDropConnect=" + this.isUseDropConnect() + ", useSchedules=" + this.isUseSchedules() + ", minimize=" + this.isMinimize() + ", timeSeriesLength=" + this.getTimeSeriesLength() + ")";
    }

    public static class Builder
    implements Cloneable {
        protected String activationFunction = "sigmoid";
        protected WeightInit weightInit = WeightInit.XAVIER;
        protected double biasInit = 0.0;
        protected Distribution dist = new NormalDistribution(0.001, 1.0);
        private double learningRate = 0.1;
        private Map<Integer, Double> learningRateAfter = new HashMap<Integer, Double>();
        private double lrScoreBasedDecay;
        private double momentum = 0.5;
        private Map<Integer, Double> momentumAfter = new HashMap<Integer, Double>();
        private double l1 = 0.0;
        private double l2 = 0.0;
        protected double dropOut = 0.0;
        protected Updater updater = Updater.SGD;
        private double rho;
        private double rmsDecay = 0.95;
        private double adamMeanDecay = 0.9;
        private double adamVarDecay = 0.999;
        private Layer layer;
        private boolean miniBatch = true;
        private int numIterations = 5;
        private int maxNumLineSearchIterations = 5;
        private long seed = System.currentTimeMillis();
        private boolean useRegularization = false;
        private boolean useSchedules = false;
        private OptimizationAlgorithm optimizationAlgo = OptimizationAlgorithm.CONJUGATE_GRADIENT;
        @Deprecated
        private boolean constrainGradientToUnitNorm = false;
        private StepFunction stepFunction = null;
        private boolean useDropConnect = false;
        private boolean minimize = true;
        @Deprecated
        private int timeSeriesLength = 1;
        private GradientNormalization gradientNormalization = GradientNormalization.None;
        private double gradientNormalizationThreshold = 1.0;

        @Deprecated
        public Builder timeSeriesLength(int timeSeriesLength) {
            this.timeSeriesLength = timeSeriesLength;
            return this;
        }

        public Builder miniBatch(boolean miniBatch) {
            this.miniBatch = miniBatch;
            return this;
        }

        public Builder useDropConnect(boolean useDropConnect) {
            this.useDropConnect = useDropConnect;
            return this;
        }

        public Builder minimize(boolean minimize) {
            this.minimize = minimize;
            return this;
        }

        public Builder maxNumLineSearchIterations(int maxNumLineSearchIterations) {
            this.maxNumLineSearchIterations = maxNumLineSearchIterations;
            return this;
        }

        public Builder layer(Layer layer) {
            this.layer = layer;
            return this;
        }

        public Builder stepFunction(StepFunction stepFunction) {
            this.stepFunction = stepFunction;
            return this;
        }

        public ListBuilder list(int size) {
            HashMap<Integer, Builder> layerMap = new HashMap<Integer, Builder>();
            for (int i = 0; i < size; ++i) {
                layerMap.put(i, this.clone());
            }
            return new ListBuilder(layerMap);
        }

        public Builder iterations(int numIterations) {
            this.numIterations = numIterations;
            return this;
        }

        public Builder seed(int seed) {
            this.seed = seed;
            Nd4j.getRandom().setSeed(seed);
            return this;
        }

        public Builder seed(long seed) {
            this.seed = seed;
            Nd4j.getRandom().setSeed(seed);
            return this;
        }

        public Builder optimizationAlgo(OptimizationAlgorithm optimizationAlgo) {
            this.optimizationAlgo = optimizationAlgo;
            return this;
        }

        @Deprecated
        public Builder constrainGradientToUnitNorm(boolean constrainGradientToUnitNorm) {
            this.constrainGradientToUnitNorm = constrainGradientToUnitNorm;
            return this;
        }

        public Builder regularization(boolean useRegularization) {
            this.useRegularization = useRegularization;
            return this;
        }

        public Builder schedules(boolean schedules) {
            this.useSchedules = schedules;
            return this;
        }

        public Builder clone() {
            try {
                Builder clone = (Builder)super.clone();
                if (clone.layer != null) {
                    clone.layer = clone.layer.clone();
                }
                if (clone.stepFunction != null) {
                    clone.stepFunction = clone.stepFunction.clone();
                }
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public Builder activation(String activationFunction) {
            this.activationFunction = activationFunction;
            return this;
        }

        public Builder weightInit(WeightInit weightInit) {
            this.weightInit = weightInit;
            return this;
        }

        public Builder biasInit(double biasInit) {
            this.biasInit = biasInit;
            return this;
        }

        public Builder dist(Distribution dist) {
            this.dist = dist;
            return this;
        }

        public Builder learningRate(double learningRate) {
            this.learningRate = learningRate;
            return this;
        }

        public Builder learningRateAfter(Map<Integer, Double> learningRateAfter) {
            this.learningRateAfter = learningRateAfter;
            return this;
        }

        public Builder learningRateScoreBasedDecayRate(double lrScoreBasedDecay) {
            this.lrScoreBasedDecay = lrScoreBasedDecay;
            return this;
        }

        public Builder l1(double l1) {
            this.l1 = l1;
            return this;
        }

        public Builder l2(double l2) {
            this.l2 = l2;
            return this;
        }

        public Builder dropOut(double dropOut) {
            this.dropOut = dropOut;
            return this;
        }

        public Builder momentum(double momentum) {
            this.momentum = momentum;
            return this;
        }

        public Builder momentumAfter(Map<Integer, Double> momentumAfter) {
            this.momentumAfter = momentumAfter;
            return this;
        }

        public Builder updater(Updater updater) {
            this.updater = updater;
            return this;
        }

        public Builder rho(double rho) {
            this.rho = rho;
            return this;
        }

        public Builder rmsDecay(double rmsDecay) {
            this.rmsDecay = rmsDecay;
            return this;
        }

        public Builder adamMeanDecay(double adamMeanDecay) {
            this.adamMeanDecay = adamMeanDecay;
            return this;
        }

        public Builder adamVarDecay(double adamVarDecay) {
            this.adamVarDecay = adamVarDecay;
            return this;
        }

        public Builder gradientNormalization(GradientNormalization gradientNormalization) {
            this.gradientNormalization = gradientNormalization;
            return this;
        }

        public Builder gradientNormalizationThreshold(double threshold) {
            this.gradientNormalizationThreshold = threshold;
            return this;
        }

        public NeuralNetConfiguration build() {
            if (this.layer == null) {
                throw new IllegalStateException("No layer defined.");
            }
            NeuralNetConfiguration conf = new NeuralNetConfiguration();
            conf.minimize = this.minimize;
            conf.maxNumLineSearchIterations = this.maxNumLineSearchIterations;
            conf.layer = this.layer;
            conf.numIterations = this.numIterations;
            conf.useRegularization = this.useRegularization;
            conf.useSchedules = this.useSchedules;
            conf.optimizationAlgo = this.optimizationAlgo;
            conf.seed = this.seed;
            conf.timeSeriesLength = this.timeSeriesLength;
            conf.stepFunction = this.stepFunction;
            conf.useDropConnect = this.useDropConnect;
            conf.miniBatch = this.miniBatch;
            if (Double.isNaN(this.layer.getLearningRate())) {
                this.layer.setLearningRate(this.learningRate);
            }
            if (this.layer.getLearningRateAfter() == null) {
                this.layer.setLearningRateAfter(this.learningRateAfter);
            }
            if (Double.isNaN(this.layer.getLrScoreBasedDecay())) {
                this.layer.setLrScoreBasedDecay(this.lrScoreBasedDecay);
            }
            if (Double.isNaN(this.layer.getL1())) {
                this.layer.setL1(this.l1);
            }
            if (Double.isNaN(this.layer.getL2())) {
                this.layer.setL2(this.l2);
            }
            if (this.layer.getActivationFunction() == null) {
                this.layer.setActivationFunction(this.activationFunction);
            }
            if (this.layer.getWeightInit() == null) {
                this.layer.setWeightInit(this.weightInit);
            }
            if (Double.isNaN(this.layer.getBiasInit())) {
                this.layer.setBiasInit(this.biasInit);
            }
            if (this.layer.getDist() == null) {
                this.layer.setDist(this.dist);
            }
            if (Double.isNaN(this.layer.getDropOut())) {
                this.layer.setDropOut(this.dropOut);
            }
            if (this.layer.getUpdater() == null) {
                this.layer.setUpdater(this.updater);
            }
            if (Double.isNaN(this.layer.getMomentum())) {
                this.layer.setMomentum(this.momentum);
            }
            if (this.layer.getMomentumAfter() == null) {
                this.layer.setMomentumAfter(this.momentumAfter);
            }
            if (Double.isNaN(this.layer.getRho())) {
                this.layer.setRho(this.rho);
            }
            if (Double.isNaN(this.layer.getRmsDecay())) {
                this.layer.setRmsDecay(this.rmsDecay);
            }
            if (Double.isNaN(this.layer.getAdamMeanDecay())) {
                this.layer.setAdamMeanDecay(this.adamMeanDecay);
            }
            if (Double.isNaN(this.layer.getAdamVarDecay())) {
                this.layer.setAdamVarDecay(this.adamVarDecay);
            }
            if (this.layer.getGradientNormalization() == null) {
                this.layer.setGradientNormalization(this.gradientNormalization);
            }
            if (Double.isNaN(this.layer.getGradientNormalizationThreshold())) {
                this.layer.setGradientNormalizationThreshold(this.gradientNormalizationThreshold);
            }
            return conf;
        }

        public String getActivationFunction() {
            return this.activationFunction;
        }

        public WeightInit getWeightInit() {
            return this.weightInit;
        }

        public double getBiasInit() {
            return this.biasInit;
        }

        public Distribution getDist() {
            return this.dist;
        }

        public double getLearningRate() {
            return this.learningRate;
        }

        public Map<Integer, Double> getLearningRateAfter() {
            return this.learningRateAfter;
        }

        public double getLrScoreBasedDecay() {
            return this.lrScoreBasedDecay;
        }

        public double getMomentum() {
            return this.momentum;
        }

        public Map<Integer, Double> getMomentumAfter() {
            return this.momentumAfter;
        }

        public double getL1() {
            return this.l1;
        }

        public double getL2() {
            return this.l2;
        }

        public double getDropOut() {
            return this.dropOut;
        }

        public Updater getUpdater() {
            return this.updater;
        }

        public double getRho() {
            return this.rho;
        }

        public double getRmsDecay() {
            return this.rmsDecay;
        }

        public double getAdamMeanDecay() {
            return this.adamMeanDecay;
        }

        public double getAdamVarDecay() {
            return this.adamVarDecay;
        }

        public Layer getLayer() {
            return this.layer;
        }

        public boolean isMiniBatch() {
            return this.miniBatch;
        }

        public int getNumIterations() {
            return this.numIterations;
        }

        public int getMaxNumLineSearchIterations() {
            return this.maxNumLineSearchIterations;
        }

        public long getSeed() {
            return this.seed;
        }

        public boolean isUseRegularization() {
            return this.useRegularization;
        }

        public boolean isUseSchedules() {
            return this.useSchedules;
        }

        public OptimizationAlgorithm getOptimizationAlgo() {
            return this.optimizationAlgo;
        }

        @Deprecated
        public boolean isConstrainGradientToUnitNorm() {
            return this.constrainGradientToUnitNorm;
        }

        public StepFunction getStepFunction() {
            return this.stepFunction;
        }

        public boolean isUseDropConnect() {
            return this.useDropConnect;
        }

        public boolean isMinimize() {
            return this.minimize;
        }

        @Deprecated
        public int getTimeSeriesLength() {
            return this.timeSeriesLength;
        }

        public GradientNormalization getGradientNormalization() {
            return this.gradientNormalization;
        }

        public double getGradientNormalizationThreshold() {
            return this.gradientNormalizationThreshold;
        }

        public void setActivationFunction(String activationFunction) {
            this.activationFunction = activationFunction;
        }

        public void setWeightInit(WeightInit weightInit) {
            this.weightInit = weightInit;
        }

        public void setBiasInit(double biasInit) {
            this.biasInit = biasInit;
        }

        public void setDist(Distribution dist) {
            this.dist = dist;
        }

        public void setLearningRate(double learningRate) {
            this.learningRate = learningRate;
        }

        public void setLearningRateAfter(Map<Integer, Double> learningRateAfter) {
            this.learningRateAfter = learningRateAfter;
        }

        public void setLrScoreBasedDecay(double lrScoreBasedDecay) {
            this.lrScoreBasedDecay = lrScoreBasedDecay;
        }

        public void setMomentum(double momentum) {
            this.momentum = momentum;
        }

        public void setMomentumAfter(Map<Integer, Double> momentumAfter) {
            this.momentumAfter = momentumAfter;
        }

        public void setL1(double l1) {
            this.l1 = l1;
        }

        public void setL2(double l2) {
            this.l2 = l2;
        }

        public void setDropOut(double dropOut) {
            this.dropOut = dropOut;
        }

        public void setUpdater(Updater updater) {
            this.updater = updater;
        }

        public void setRho(double rho) {
            this.rho = rho;
        }

        public void setRmsDecay(double rmsDecay) {
            this.rmsDecay = rmsDecay;
        }

        public void setAdamMeanDecay(double adamMeanDecay) {
            this.adamMeanDecay = adamMeanDecay;
        }

        public void setAdamVarDecay(double adamVarDecay) {
            this.adamVarDecay = adamVarDecay;
        }

        public void setLayer(Layer layer) {
            this.layer = layer;
        }

        public void setMiniBatch(boolean miniBatch) {
            this.miniBatch = miniBatch;
        }

        public void setNumIterations(int numIterations) {
            this.numIterations = numIterations;
        }

        public void setMaxNumLineSearchIterations(int maxNumLineSearchIterations) {
            this.maxNumLineSearchIterations = maxNumLineSearchIterations;
        }

        public void setSeed(long seed) {
            this.seed = seed;
        }

        public void setUseRegularization(boolean useRegularization) {
            this.useRegularization = useRegularization;
        }

        public void setUseSchedules(boolean useSchedules) {
            this.useSchedules = useSchedules;
        }

        public void setOptimizationAlgo(OptimizationAlgorithm optimizationAlgo) {
            this.optimizationAlgo = optimizationAlgo;
        }

        @Deprecated
        public void setConstrainGradientToUnitNorm(boolean constrainGradientToUnitNorm) {
            this.constrainGradientToUnitNorm = constrainGradientToUnitNorm;
        }

        public void setStepFunction(StepFunction stepFunction) {
            this.stepFunction = stepFunction;
        }

        public void setUseDropConnect(boolean useDropConnect) {
            this.useDropConnect = useDropConnect;
        }

        public void setMinimize(boolean minimize) {
            this.minimize = minimize;
        }

        @Deprecated
        public void setTimeSeriesLength(int timeSeriesLength) {
            this.timeSeriesLength = timeSeriesLength;
        }

        public void setGradientNormalization(GradientNormalization gradientNormalization) {
            this.gradientNormalization = gradientNormalization;
        }

        public void setGradientNormalizationThreshold(double gradientNormalizationThreshold) {
            this.gradientNormalizationThreshold = gradientNormalizationThreshold;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder other = (Builder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$activationFunction = this.getActivationFunction();
            String other$activationFunction = other.getActivationFunction();
            if (this$activationFunction == null ? other$activationFunction != null : !this$activationFunction.equals(other$activationFunction)) {
                return false;
            }
            WeightInit this$weightInit = this.getWeightInit();
            WeightInit other$weightInit = other.getWeightInit();
            if (this$weightInit == null ? other$weightInit != null : !((Object)((Object)this$weightInit)).equals((Object)other$weightInit)) {
                return false;
            }
            if (Double.compare(this.getBiasInit(), other.getBiasInit()) != 0) {
                return false;
            }
            Distribution this$dist = this.getDist();
            Distribution other$dist = other.getDist();
            if (this$dist == null ? other$dist != null : !this$dist.equals(other$dist)) {
                return false;
            }
            if (Double.compare(this.getLearningRate(), other.getLearningRate()) != 0) {
                return false;
            }
            Map<Integer, Double> this$learningRateAfter = this.getLearningRateAfter();
            Map<Integer, Double> other$learningRateAfter = other.getLearningRateAfter();
            if (this$learningRateAfter == null ? other$learningRateAfter != null : !((Object)this$learningRateAfter).equals(other$learningRateAfter)) {
                return false;
            }
            if (Double.compare(this.getLrScoreBasedDecay(), other.getLrScoreBasedDecay()) != 0) {
                return false;
            }
            if (Double.compare(this.getMomentum(), other.getMomentum()) != 0) {
                return false;
            }
            Map<Integer, Double> this$momentumAfter = this.getMomentumAfter();
            Map<Integer, Double> other$momentumAfter = other.getMomentumAfter();
            if (this$momentumAfter == null ? other$momentumAfter != null : !((Object)this$momentumAfter).equals(other$momentumAfter)) {
                return false;
            }
            if (Double.compare(this.getL1(), other.getL1()) != 0) {
                return false;
            }
            if (Double.compare(this.getL2(), other.getL2()) != 0) {
                return false;
            }
            if (Double.compare(this.getDropOut(), other.getDropOut()) != 0) {
                return false;
            }
            Updater this$updater = this.getUpdater();
            Updater other$updater = other.getUpdater();
            if (this$updater == null ? other$updater != null : !((Object)((Object)this$updater)).equals((Object)other$updater)) {
                return false;
            }
            if (Double.compare(this.getRho(), other.getRho()) != 0) {
                return false;
            }
            if (Double.compare(this.getRmsDecay(), other.getRmsDecay()) != 0) {
                return false;
            }
            if (Double.compare(this.getAdamMeanDecay(), other.getAdamMeanDecay()) != 0) {
                return false;
            }
            if (Double.compare(this.getAdamVarDecay(), other.getAdamVarDecay()) != 0) {
                return false;
            }
            Layer this$layer = this.getLayer();
            Layer other$layer = other.getLayer();
            if (this$layer == null ? other$layer != null : !((Object)this$layer).equals(other$layer)) {
                return false;
            }
            if (this.isMiniBatch() != other.isMiniBatch()) {
                return false;
            }
            if (this.getNumIterations() != other.getNumIterations()) {
                return false;
            }
            if (this.getMaxNumLineSearchIterations() != other.getMaxNumLineSearchIterations()) {
                return false;
            }
            if (this.getSeed() != other.getSeed()) {
                return false;
            }
            if (this.isUseRegularization() != other.isUseRegularization()) {
                return false;
            }
            if (this.isUseSchedules() != other.isUseSchedules()) {
                return false;
            }
            OptimizationAlgorithm this$optimizationAlgo = this.getOptimizationAlgo();
            OptimizationAlgorithm other$optimizationAlgo = other.getOptimizationAlgo();
            if (this$optimizationAlgo == null ? other$optimizationAlgo != null : !((Object)((Object)this$optimizationAlgo)).equals((Object)other$optimizationAlgo)) {
                return false;
            }
            if (this.isConstrainGradientToUnitNorm() != other.isConstrainGradientToUnitNorm()) {
                return false;
            }
            StepFunction this$stepFunction = this.getStepFunction();
            StepFunction other$stepFunction = other.getStepFunction();
            if (this$stepFunction == null ? other$stepFunction != null : !this$stepFunction.equals(other$stepFunction)) {
                return false;
            }
            if (this.isUseDropConnect() != other.isUseDropConnect()) {
                return false;
            }
            if (this.isMinimize() != other.isMinimize()) {
                return false;
            }
            if (this.getTimeSeriesLength() != other.getTimeSeriesLength()) {
                return false;
            }
            GradientNormalization this$gradientNormalization = this.getGradientNormalization();
            GradientNormalization other$gradientNormalization = other.getGradientNormalization();
            if (this$gradientNormalization == null ? other$gradientNormalization != null : !((Object)((Object)this$gradientNormalization)).equals((Object)other$gradientNormalization)) {
                return false;
            }
            return Double.compare(this.getGradientNormalizationThreshold(), other.getGradientNormalizationThreshold()) == 0;
        }

        protected boolean canEqual(Object other) {
            return other instanceof Builder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $activationFunction = this.getActivationFunction();
            result = result * 59 + ($activationFunction == null ? 0 : $activationFunction.hashCode());
            WeightInit $weightInit = this.getWeightInit();
            result = result * 59 + ($weightInit == null ? 0 : ((Object)((Object)$weightInit)).hashCode());
            long $biasInit = Double.doubleToLongBits(this.getBiasInit());
            result = result * 59 + (int)($biasInit >>> 32 ^ $biasInit);
            Distribution $dist = this.getDist();
            result = result * 59 + ($dist == null ? 0 : $dist.hashCode());
            long $learningRate = Double.doubleToLongBits(this.getLearningRate());
            result = result * 59 + (int)($learningRate >>> 32 ^ $learningRate);
            Map<Integer, Double> $learningRateAfter = this.getLearningRateAfter();
            result = result * 59 + ($learningRateAfter == null ? 0 : ((Object)$learningRateAfter).hashCode());
            long $lrScoreBasedDecay = Double.doubleToLongBits(this.getLrScoreBasedDecay());
            result = result * 59 + (int)($lrScoreBasedDecay >>> 32 ^ $lrScoreBasedDecay);
            long $momentum = Double.doubleToLongBits(this.getMomentum());
            result = result * 59 + (int)($momentum >>> 32 ^ $momentum);
            Map<Integer, Double> $momentumAfter = this.getMomentumAfter();
            result = result * 59 + ($momentumAfter == null ? 0 : ((Object)$momentumAfter).hashCode());
            long $l1 = Double.doubleToLongBits(this.getL1());
            result = result * 59 + (int)($l1 >>> 32 ^ $l1);
            long $l2 = Double.doubleToLongBits(this.getL2());
            result = result * 59 + (int)($l2 >>> 32 ^ $l2);
            long $dropOut = Double.doubleToLongBits(this.getDropOut());
            result = result * 59 + (int)($dropOut >>> 32 ^ $dropOut);
            Updater $updater = this.getUpdater();
            result = result * 59 + ($updater == null ? 0 : ((Object)((Object)$updater)).hashCode());
            long $rho = Double.doubleToLongBits(this.getRho());
            result = result * 59 + (int)($rho >>> 32 ^ $rho);
            long $rmsDecay = Double.doubleToLongBits(this.getRmsDecay());
            result = result * 59 + (int)($rmsDecay >>> 32 ^ $rmsDecay);
            long $adamMeanDecay = Double.doubleToLongBits(this.getAdamMeanDecay());
            result = result * 59 + (int)($adamMeanDecay >>> 32 ^ $adamMeanDecay);
            long $adamVarDecay = Double.doubleToLongBits(this.getAdamVarDecay());
            result = result * 59 + (int)($adamVarDecay >>> 32 ^ $adamVarDecay);
            Layer $layer = this.getLayer();
            result = result * 59 + ($layer == null ? 0 : ((Object)$layer).hashCode());
            result = result * 59 + (this.isMiniBatch() ? 79 : 97);
            result = result * 59 + this.getNumIterations();
            result = result * 59 + this.getMaxNumLineSearchIterations();
            long $seed = this.getSeed();
            result = result * 59 + (int)($seed >>> 32 ^ $seed);
            result = result * 59 + (this.isUseRegularization() ? 79 : 97);
            result = result * 59 + (this.isUseSchedules() ? 79 : 97);
            OptimizationAlgorithm $optimizationAlgo = this.getOptimizationAlgo();
            result = result * 59 + ($optimizationAlgo == null ? 0 : ((Object)((Object)$optimizationAlgo)).hashCode());
            result = result * 59 + (this.isConstrainGradientToUnitNorm() ? 79 : 97);
            StepFunction $stepFunction = this.getStepFunction();
            result = result * 59 + ($stepFunction == null ? 0 : $stepFunction.hashCode());
            result = result * 59 + (this.isUseDropConnect() ? 79 : 97);
            result = result * 59 + (this.isMinimize() ? 79 : 97);
            result = result * 59 + this.getTimeSeriesLength();
            GradientNormalization $gradientNormalization = this.getGradientNormalization();
            result = result * 59 + ($gradientNormalization == null ? 0 : ((Object)((Object)$gradientNormalization)).hashCode());
            long $gradientNormalizationThreshold = Double.doubleToLongBits(this.getGradientNormalizationThreshold());
            result = result * 59 + (int)($gradientNormalizationThreshold >>> 32 ^ $gradientNormalizationThreshold);
            return result;
        }

        public String toString() {
            return "NeuralNetConfiguration.Builder(activationFunction=" + this.getActivationFunction() + ", weightInit=" + (Object)((Object)this.getWeightInit()) + ", biasInit=" + this.getBiasInit() + ", dist=" + this.getDist() + ", learningRate=" + this.getLearningRate() + ", learningRateAfter=" + this.getLearningRateAfter() + ", lrScoreBasedDecay=" + this.getLrScoreBasedDecay() + ", momentum=" + this.getMomentum() + ", momentumAfter=" + this.getMomentumAfter() + ", l1=" + this.getL1() + ", l2=" + this.getL2() + ", dropOut=" + this.getDropOut() + ", updater=" + (Object)((Object)this.getUpdater()) + ", rho=" + this.getRho() + ", rmsDecay=" + this.getRmsDecay() + ", adamMeanDecay=" + this.getAdamMeanDecay() + ", adamVarDecay=" + this.getAdamVarDecay() + ", layer=" + this.getLayer() + ", miniBatch=" + this.isMiniBatch() + ", numIterations=" + this.getNumIterations() + ", maxNumLineSearchIterations=" + this.getMaxNumLineSearchIterations() + ", seed=" + this.getSeed() + ", useRegularization=" + this.isUseRegularization() + ", useSchedules=" + this.isUseSchedules() + ", optimizationAlgo=" + (Object)((Object)this.getOptimizationAlgo()) + ", constrainGradientToUnitNorm=" + this.isConstrainGradientToUnitNorm() + ", stepFunction=" + this.getStepFunction() + ", useDropConnect=" + this.isUseDropConnect() + ", minimize=" + this.isMinimize() + ", timeSeriesLength=" + this.getTimeSeriesLength() + ", gradientNormalization=" + (Object)((Object)this.getGradientNormalization()) + ", gradientNormalizationThreshold=" + this.getGradientNormalizationThreshold() + ")";
        }
    }

    public static class ListBuilder
    extends MultiLayerConfiguration.Builder {
        private Map<Integer, Builder> layerwise;

        public ListBuilder(Map<Integer, Builder> layerMap) {
            this.layerwise = layerMap;
        }

        @Override
        public ListBuilder backprop(boolean backprop) {
            this.backprop = backprop;
            return this;
        }

        @Override
        public ListBuilder pretrain(boolean pretrain) {
            this.pretrain = pretrain;
            return this;
        }

        public ListBuilder layer(int ind, Layer layer) {
            if (this.layerwise.get(0) == null && ind != 0) {
                throw new IllegalArgumentException("LayerZeroIndexError: Layer index must start from 0");
            }
            if (this.layerwise.size() < ind + 1) {
                throw new IllegalArgumentException("IndexOutOfBoundsError: Layer index exceeds listed size");
            }
            Builder builderWithLayer = this.layerwise.get(ind).layer(layer);
            this.layerwise.put(ind, builderWithLayer);
            return this;
        }

        public Map<Integer, Builder> getLayerwise() {
            return this.layerwise;
        }

        @Override
        public MultiLayerConfiguration build() {
            ArrayList<NeuralNetConfiguration> list = new ArrayList<NeuralNetConfiguration>();
            for (int i = 0; i < this.layerwise.size(); ++i) {
                list.add(this.layerwise.get(i).build());
            }
            return new MultiLayerConfiguration.Builder().backprop(this.backprop).inputPreProcessors(this.inputPreProcessors).pretrain(this.pretrain).backpropType(this.backpropType).tBPTTForwardLength(this.tbpttFwdLength).tBPTTBackwardLength(this.tbpttBackLength).redistributeParams(this.redistributeParams).confs(list).build();
        }
    }
}

