/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.fetchers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.deeplearning4j.base.MnistFetcher;
import org.deeplearning4j.datasets.fetchers.BaseDataFetcher;
import org.deeplearning4j.datasets.mnist.MnistManager;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.util.ArrayUtil;

public class MnistDataFetcher
extends BaseDataFetcher {
    private static final long serialVersionUID = -3218754671561789818L;
    private transient MnistManager man;
    public static final int NUM_EXAMPLES = 60000;
    private static final String TEMP_ROOT = System.getProperty("user.home");
    private static final String MNIST_ROOT = TEMP_ROOT + File.separator + "MNIST" + File.separator;
    private boolean binarize = true;

    public MnistDataFetcher(boolean binarize) throws IOException {
        if (!new File(MNIST_ROOT).exists()) {
            new MnistFetcher().downloadAndUntar();
        }
        try {
            this.man = new MnistManager(MNIST_ROOT + "images-idx1-ubyte", MNIST_ROOT + "labels-idx1-ubyte");
        }
        catch (Exception e) {
            FileUtils.deleteDirectory((File)new File(MNIST_ROOT));
            new MnistFetcher().downloadAndUntar();
            this.man = new MnistManager(MNIST_ROOT + "images-idx1-ubyte", MNIST_ROOT + "labels-idx1-ubyte");
        }
        this.numOutcomes = 10;
        this.binarize = binarize;
        this.totalExamples = 60000;
        this.cursor = 0;
        this.inputColumns = this.man.getImages().getEntryLength();
    }

    public MnistDataFetcher() throws IOException {
        this(true);
    }

    @Override
    public void fetch(int numExamples) {
        if (!this.hasMore()) {
            throw new IllegalStateException("Unable to getFromOrigin more; there are no more images");
        }
        ArrayList<DataSet> toConvert = new ArrayList<DataSet>();
        int i = 0;
        while (i < numExamples && this.hasMore()) {
            if (this.man == null) {
                try {
                    this.man = new MnistManager(MNIST_ROOT + "images-idx1-ubyte", MNIST_ROOT + "labels-idx1-ubyte");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.man.setCurrent(this.cursor);
            try {
                INDArray in = ArrayUtil.toNDArray((int[])ArrayUtil.flatten((int[][])this.man.readImage()));
                if (this.binarize) {
                    for (int d = 0; d < in.length(); ++d) {
                        if (in.getDouble(d) > 30.0) {
                            in.putScalar(d, 1);
                            continue;
                        }
                        in.putScalar(d, 0);
                    }
                } else {
                    in.divi((Number)255);
                }
                INDArray out = this.createOutputVector(this.man.readLabel());
                boolean found = false;
                for (int col = 0; col < out.length(); ++col) {
                    if (!(out.getDouble(col) > 0.0)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    throw new IllegalStateException("Found a matrix without an outcome");
                }
                toConvert.add(new DataSet(in, out));
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to read image");
            }
            ++i;
            ++this.cursor;
        }
        this.initializeCurrFromList(toConvert);
    }

    @Override
    public void reset() {
        this.cursor = 0;
        this.curr = null;
    }

    @Override
    public DataSet next() {
        DataSet next = super.next();
        return next;
    }
}

