/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.factory;

import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.LayerFactory;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.BasePretrainNetwork;
import org.deeplearning4j.nn.conf.layers.BatchNormalization;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.GRU;
import org.deeplearning4j.nn.conf.layers.GravesLSTM;
import org.deeplearning4j.nn.conf.layers.ImageLSTM;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.LocalResponseNormalization;
import org.deeplearning4j.nn.conf.layers.RecursiveAutoEncoder;
import org.deeplearning4j.nn.conf.layers.SubsamplingLayer;
import org.deeplearning4j.nn.layers.factory.BatchNormalizationLayerFactory;
import org.deeplearning4j.nn.layers.factory.ConvolutionLayerFactory;
import org.deeplearning4j.nn.layers.factory.DefaultLayerFactory;
import org.deeplearning4j.nn.layers.factory.GRULayerFactory;
import org.deeplearning4j.nn.layers.factory.GravesLSTMLayerFactory;
import org.deeplearning4j.nn.layers.factory.ImageLSTMLayerFactory;
import org.deeplearning4j.nn.layers.factory.LocalResponseNormalizationFactory;
import org.deeplearning4j.nn.layers.factory.PretrainLayerFactory;
import org.deeplearning4j.nn.layers.factory.RecursiveAutoEncoderLayerFactory;
import org.deeplearning4j.nn.layers.factory.SubsampleLayerFactory;

public class LayerFactories {
    public static LayerFactory getFactory(NeuralNetConfiguration conf) {
        return LayerFactories.getFactory(conf.getLayer());
    }

    public static LayerFactory getFactory(Layer layer) {
        Class<?> clazz = layer.getClass();
        if (clazz.equals(ImageLSTM.class)) {
            return new ImageLSTMLayerFactory(ImageLSTM.class);
        }
        if (clazz.equals(GravesLSTM.class)) {
            return new GravesLSTMLayerFactory(GravesLSTM.class);
        }
        if (clazz.equals(GRU.class)) {
            return new GRULayerFactory(GRU.class);
        }
        if (RecursiveAutoEncoder.class.isAssignableFrom(clazz)) {
            return new RecursiveAutoEncoderLayerFactory(RecursiveAutoEncoder.class);
        }
        if (BasePretrainNetwork.class.isAssignableFrom(clazz)) {
            return new PretrainLayerFactory(clazz);
        }
        if (ConvolutionLayer.class.isAssignableFrom(clazz)) {
            return new ConvolutionLayerFactory(clazz);
        }
        if (SubsamplingLayer.class.isAssignableFrom(clazz)) {
            return new SubsampleLayerFactory(clazz);
        }
        if (BatchNormalization.class.isAssignableFrom(clazz)) {
            return new BatchNormalizationLayerFactory(clazz);
        }
        if (LocalResponseNormalization.class.isAssignableFrom(clazz)) {
            return new LocalResponseNormalizationFactory(clazz);
        }
        return new DefaultLayerFactory(clazz);
    }

    public static Layer.Type typeForFactory(NeuralNetConfiguration conf) {
        LayerFactory layerFactory = LayerFactories.getFactory(conf);
        if (layerFactory instanceof ConvolutionLayerFactory || layerFactory instanceof SubsampleLayerFactory) {
            return Layer.Type.CONVOLUTIONAL;
        }
        if (layerFactory instanceof ImageLSTMLayerFactory || layerFactory instanceof GravesLSTMLayerFactory || layerFactory instanceof GRULayerFactory) {
            return Layer.Type.RECURRENT;
        }
        if (layerFactory instanceof RecursiveAutoEncoderLayerFactory) {
            return Layer.Type.RECURSIVE;
        }
        if (layerFactory instanceof DefaultLayerFactory || layerFactory instanceof PretrainLayerFactory) {
            return Layer.Type.FEED_FORWARD;
        }
        throw new IllegalArgumentException("Unknown layer type");
    }
}

