/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution;

import java.util.Arrays;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.BaseLayer;
import org.deeplearning4j.util.Dropout;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.impl.vector.VectorAddOp;
import org.nd4j.linalg.convolution.Convolution;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.ops.transforms.Transforms;

public class ConvolutionLayer
extends BaseLayer<org.deeplearning4j.nn.conf.layers.ConvolutionLayer> {
    protected INDArray col;

    public ConvolutionLayer(NeuralNetConfiguration conf) {
        super(conf);
    }

    public ConvolutionLayer(NeuralNetConfiguration conf, INDArray input) {
        super(conf, input);
    }

    public void setCol(INDArray col) {
        this.col = col;
    }

    @Override
    public double calcL2() {
        if (!this.conf.isUseRegularization() || this.conf.getLayer().getL2() <= 0.0) {
            return 0.0;
        }
        return 0.5 * this.conf.getLayer().getL2() * Transforms.pow((INDArray)this.getParam("W"), (Number)2).sum(new int[]{Integer.MAX_VALUE}).getDouble(0);
    }

    @Override
    public double calcL1() {
        if (!this.conf.isUseRegularization() || this.conf.getLayer().getL1() <= 0.0) {
            return 0.0;
        }
        return this.conf.getLayer().getL1() * Transforms.abs((INDArray)this.getParam("W")).sum(new int[]{Integer.MAX_VALUE}).getDouble(0);
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.CONVOLUTIONAL;
    }

    public INDArray calculateDelta(INDArray epsilon) {
        INDArray z = this.preOutput(true);
        INDArray activationDerivative = Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createTransform(this.conf().getLayer().getActivationFunction(), z).derivative());
        if (!Arrays.equals(z.shape(), activationDerivative.shape())) {
            throw new IllegalStateException("Shapes must be same");
        }
        return epsilon.muli(activationDerivative);
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon) {
        int inputHeight = this.input().size(-2);
        int inputWidth = this.input().size(-1);
        INDArray weights = this.getParam("W");
        INDArray delta = this.calculateDelta(epsilon);
        DefaultGradient retGradient = new DefaultGradient();
        retGradient.setGradientFor("b", delta.sum(new int[]{0, 2, 3}));
        INDArray weightGradient = Nd4j.tensorMmul((INDArray)delta, (INDArray)this.col, (int[][])new int[][]{{0, 2, 3}, {0, 4, 5}});
        retGradient.setGradientFor("W", weightGradient);
        INDArray nextEpsilon = Nd4j.tensorMmul((INDArray)weights, (INDArray)delta, (int[][])new int[][]{{0}, {1}});
        nextEpsilon = Nd4j.rollAxis((INDArray)nextEpsilon, (int)3);
        nextEpsilon = Convolution.col2im((INDArray)nextEpsilon, (int[])((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getStride(), (int[])((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getPadding(), (int)inputHeight, (int)inputWidth);
        return new Pair<Gradient, INDArray>(retGradient, nextEpsilon);
    }

    public INDArray preOutput(boolean training) {
        INDArray Weights = this.getParam("W");
        INDArray bias = this.getParam("b");
        if (this.conf.isUseDropConnect() && training && this.conf.getLayer().getDropOut() > 0.0) {
            Weights = Dropout.applyDropConnect(this, "W");
        }
        INDArray z = Nd4j.tensorMmul((INDArray)this.col, (INDArray)Weights, (int[][])new int[][]{{1, 2, 3}, {1, 2, 3}});
        VectorAddOp op = new VectorAddOp(z, bias, z, 3);
        Nd4j.getExecutioner().exec((Op)op);
        return Nd4j.rollAxis((INDArray)z, (int)3, (int)1);
    }

    @Override
    public INDArray activate(boolean training) {
        if (this.input == null) {
            throw new IllegalArgumentException("No null input allowed");
        }
        this.applyDropOutIfNecessary(this.input, training);
        this.col = Convolution.im2col((INDArray)this.input, (int[])((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getKernelSize(), (int[])((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getStride(), (int[])((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getPadding());
        INDArray z = this.preOutput(training);
        INDArray activation = Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createTransform(this.conf.getLayer().getActivationFunction(), z));
        return activation;
    }

    @Override
    public Layer transpose() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Gradient calcGradient(Gradient layerError, INDArray indArray) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void fit(INDArray input) {
    }

    @Override
    public void merge(Layer layer, int batchSize) {
        throw new UnsupportedOperationException();
    }
}

