/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.params;

import java.util.Map;
import org.canova.api.conf.Configuration;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.BatchNormalization;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.ArrayUtil;

public class BatchNormalizationParamInitializer
implements ParamInitializer {
    public static final String GAMMA = "gamma";
    public static final String BETA = "beta";
    public static final String AVG_MEAN = "avgMean";
    public static final String AVG_VAR = "avgVar";
    public static final String GAMMA_GRADIENT = "gammaGradient";
    public static final String BETA_GRADIENT = "betaGradient";

    @Override
    public void init(Map<String, INDArray> params, NeuralNetConfiguration conf) {
        BatchNormalization normalization = (BatchNormalization)conf.getLayer();
        int size = ArrayUtil.prod((int[])normalization.getShape());
        params.put(AVG_MEAN, Nd4j.zeros((int[])new int[]{1, size, 1}));
        params.put(AVG_VAR, Nd4j.zerosLike((INDArray)params.get(AVG_MEAN)));
        params.put(GAMMA, Nd4j.onesLike((INDArray)params.get(AVG_MEAN)));
        params.put(GAMMA_GRADIENT, Nd4j.zerosLike((INDArray)params.get(AVG_MEAN)));
        params.put(BETA, Nd4j.zerosLike((INDArray)params.get(AVG_MEAN)));
        params.put(BETA_GRADIENT, Nd4j.zerosLike((INDArray)params.get(AVG_MEAN)));
    }

    @Override
    public void init(Map<String, INDArray> params, NeuralNetConfiguration conf, Configuration extraConf) {
    }
}

