/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import org.deeplearning4j.nn.conf.Updater;
import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.deeplearning4j.nn.conf.distribution.NormalDistribution;
import org.deeplearning4j.nn.conf.layers.AutoEncoder;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.DenseLayer;
import org.deeplearning4j.nn.conf.layers.GRU;
import org.deeplearning4j.nn.conf.layers.GravesLSTM;
import org.deeplearning4j.nn.conf.layers.ImageLSTM;
import org.deeplearning4j.nn.conf.layers.OutputLayer;
import org.deeplearning4j.nn.conf.layers.RBM;
import org.deeplearning4j.nn.conf.layers.RecursiveAutoEncoder;
import org.deeplearning4j.nn.conf.layers.RnnOutputLayer;
import org.deeplearning4j.nn.conf.layers.SubsamplingLayer;
import org.deeplearning4j.nn.weights.WeightInit;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.WRAPPER_OBJECT)
@JsonSubTypes(value={@JsonSubTypes.Type(value=AutoEncoder.class, name="autoEncoder"), @JsonSubTypes.Type(value=ConvolutionLayer.class, name="convolution"), @JsonSubTypes.Type(value=ImageLSTM.class, name="imageLSTM"), @JsonSubTypes.Type(value=GravesLSTM.class, name="gravesLSTM"), @JsonSubTypes.Type(value=GRU.class, name="gru"), @JsonSubTypes.Type(value=OutputLayer.class, name="output"), @JsonSubTypes.Type(value=RnnOutputLayer.class, name="rnnoutput"), @JsonSubTypes.Type(value=RBM.class, name="RBM"), @JsonSubTypes.Type(value=DenseLayer.class, name="dense"), @JsonSubTypes.Type(value=RecursiveAutoEncoder.class, name="recursiveAutoEncoder"), @JsonSubTypes.Type(value=SubsamplingLayer.class, name="subsampling")})
public abstract class Layer
implements Serializable,
Cloneable {
    protected String activationFunction;
    protected WeightInit weightInit;
    protected double biasInit;
    protected Distribution dist;
    protected double dropOut;
    protected Updater updater;
    protected double l1;
    protected double l2;
    protected double lr;

    public Layer(Builder builder) {
        this.activationFunction = builder.activationFunction;
        this.weightInit = builder.weightInit;
        this.biasInit = builder.biasInit;
        this.dist = builder.dist;
        this.dropOut = builder.dropOut;
        this.updater = builder.updater;
        this.l1 = builder.l1;
        this.l2 = builder.l2;
        this.lr = builder.lr;
    }

    public Layer clone() {
        try {
            Layer clone = (Layer)super.clone();
            if (clone.dist != null) {
                clone.dist = clone.dist.clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String getActivationFunction() {
        return this.activationFunction;
    }

    public WeightInit getWeightInit() {
        return this.weightInit;
    }

    public double getBiasInit() {
        return this.biasInit;
    }

    public Distribution getDist() {
        return this.dist;
    }

    public double getDropOut() {
        return this.dropOut;
    }

    public Updater getUpdater() {
        return this.updater;
    }

    public double getL1() {
        return this.l1;
    }

    public double getL2() {
        return this.l2;
    }

    public double getLr() {
        return this.lr;
    }

    public void setActivationFunction(String activationFunction) {
        this.activationFunction = activationFunction;
    }

    public void setWeightInit(WeightInit weightInit) {
        this.weightInit = weightInit;
    }

    public void setBiasInit(double biasInit) {
        this.biasInit = biasInit;
    }

    public void setDist(Distribution dist) {
        this.dist = dist;
    }

    public void setDropOut(double dropOut) {
        this.dropOut = dropOut;
    }

    public void setUpdater(Updater updater) {
        this.updater = updater;
    }

    public void setL1(double l1) {
        this.l1 = l1;
    }

    public void setL2(double l2) {
        this.l2 = l2;
    }

    public void setLr(double lr) {
        this.lr = lr;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Layer)) {
            return false;
        }
        Layer other = (Layer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$activationFunction = this.getActivationFunction();
        String other$activationFunction = other.getActivationFunction();
        if (this$activationFunction == null ? other$activationFunction != null : !this$activationFunction.equals(other$activationFunction)) {
            return false;
        }
        WeightInit this$weightInit = this.getWeightInit();
        WeightInit other$weightInit = other.getWeightInit();
        if (this$weightInit == null ? other$weightInit != null : !((Object)((Object)this$weightInit)).equals((Object)other$weightInit)) {
            return false;
        }
        if (Double.compare(this.getBiasInit(), other.getBiasInit()) != 0) {
            return false;
        }
        Distribution this$dist = this.getDist();
        Distribution other$dist = other.getDist();
        if (this$dist == null ? other$dist != null : !this$dist.equals(other$dist)) {
            return false;
        }
        if (Double.compare(this.getDropOut(), other.getDropOut()) != 0) {
            return false;
        }
        Updater this$updater = this.getUpdater();
        Updater other$updater = other.getUpdater();
        if (this$updater == null ? other$updater != null : !((Object)((Object)this$updater)).equals((Object)other$updater)) {
            return false;
        }
        if (Double.compare(this.getL1(), other.getL1()) != 0) {
            return false;
        }
        if (Double.compare(this.getL2(), other.getL2()) != 0) {
            return false;
        }
        return Double.compare(this.getLr(), other.getLr()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Layer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $activationFunction = this.getActivationFunction();
        result = result * 59 + ($activationFunction == null ? 0 : $activationFunction.hashCode());
        WeightInit $weightInit = this.getWeightInit();
        result = result * 59 + ($weightInit == null ? 0 : ((Object)((Object)$weightInit)).hashCode());
        long $biasInit = Double.doubleToLongBits(this.getBiasInit());
        result = result * 59 + (int)($biasInit >>> 32 ^ $biasInit);
        Distribution $dist = this.getDist();
        result = result * 59 + ($dist == null ? 0 : $dist.hashCode());
        long $dropOut = Double.doubleToLongBits(this.getDropOut());
        result = result * 59 + (int)($dropOut >>> 32 ^ $dropOut);
        Updater $updater = this.getUpdater();
        result = result * 59 + ($updater == null ? 0 : ((Object)((Object)$updater)).hashCode());
        long $l1 = Double.doubleToLongBits(this.getL1());
        result = result * 59 + (int)($l1 >>> 32 ^ $l1);
        long $l2 = Double.doubleToLongBits(this.getL2());
        result = result * 59 + (int)($l2 >>> 32 ^ $l2);
        long $lr = Double.doubleToLongBits(this.getLr());
        result = result * 59 + (int)($lr >>> 32 ^ $lr);
        return result;
    }

    public String toString() {
        return "Layer(activationFunction=" + this.getActivationFunction() + ", weightInit=" + (Object)((Object)this.getWeightInit()) + ", biasInit=" + this.getBiasInit() + ", dist=" + this.getDist() + ", dropOut=" + this.getDropOut() + ", updater=" + (Object)((Object)this.getUpdater()) + ", l1=" + this.getL1() + ", l2=" + this.getL2() + ", lr=" + this.getLr() + ")";
    }

    public Layer() {
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String activationFunction = "sigmoid";
        protected WeightInit weightInit = WeightInit.VI;
        protected double biasInit = 0.0;
        protected Distribution dist = new NormalDistribution(0.001, 1.0);
        protected double dropOut = 0.0;
        protected Updater updater = Updater.ADAGRAD;
        protected double l1 = Double.NaN;
        protected double l2 = Double.NaN;
        protected double lr = Double.NaN;

        public T activation(String activationFunction) {
            this.activationFunction = activationFunction;
            return (T)this;
        }

        public T weightInit(WeightInit weightInit) {
            this.weightInit = weightInit;
            return (T)this;
        }

        public T biasInit(double biasInit) {
            this.biasInit = biasInit;
            return (T)this;
        }

        public T dist(Distribution dist) {
            this.dist = dist;
            return (T)this;
        }

        public T dropOut(double dropOut) {
            this.dropOut = dropOut;
            return (T)this;
        }

        public T updater(Updater updater) {
            this.updater = updater;
            return (T)this;
        }

        public T l1(double l1) {
            this.l1 = l1;
            return (T)this;
        }

        public T l2(double l2) {
            this.l2 = l2;
            return (T)this;
        }

        public T learningRate(double lr) {
            this.lr = lr;
            return (T)this;
        }

        public abstract <E extends Layer> E build();
    }
}

