/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.rearrange;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class LocalUnstructuredDataFormatter {
    private File splitRootDir;
    private File rootDir;
    private File train;
    private File test;
    private LabelingType labelingType;
    private int numExamplesTotal = -1;
    private int numTestExamples = -1;
    private double percentTrain = 0.0;
    private int numExamplesToTrainOn = -1;
    private List<String> allFiles = new ArrayList<String>();

    public LocalUnstructuredDataFormatter(File destinationRootDir, File rootDir, LabelingType labelingType, double percentTrain) {
        this.percentTrain = percentTrain;
        this.rootDir = rootDir;
        this.splitRootDir = new File(destinationRootDir, "split");
        if (this.splitRootDir.exists()) {
            throw new IllegalStateException("Train/test split already exists");
        }
        this.train = new File(this.splitRootDir, "train");
        this.test = new File(this.splitRootDir, "test");
        this.train.mkdirs();
        this.test.mkdirs();
        this.labelingType = labelingType;
    }

    public void rearrange() {
        int numExampleForTrain;
        Iterator files = FileUtils.iterateFiles((File)this.rootDir, null, (boolean)true);
        while (files.hasNext()) {
            this.allFiles.add(((File)files.next()).getAbsolutePath());
        }
        this.numExamplesTotal = this.allFiles.size();
        this.numExamplesToTrainOn = numExampleForTrain = (int)(this.percentTrain * (double)this.numExamplesTotal);
        this.numTestExamples = this.numExamplesTotal - numExampleForTrain;
        Collections.shuffle(this.allFiles);
        for (int i = 0; i < this.numExamplesTotal; ++i) {
            String dir = this.getNewDestination(this.allFiles.get(i), i < numExampleForTrain);
            File origin = new File(this.allFiles.get(i));
            File newDir = new File(dir);
            newDir.getParentFile().mkdirs();
            try {
                Files.copy((File)origin, (File)newDir);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String getNewDestination(String path, boolean train) {
        File file = new File(path);
        switch (this.labelingType) {
            case NAME: {
                if (train) {
                    File dir = new File(this.train, this.getNameLabel(path));
                    File name = new File(dir, file.getName());
                    return name.getAbsolutePath();
                }
                File dir = new File(this.test, this.getNameLabel(path));
                File name = new File(dir, file.getName());
                return name.getAbsolutePath();
            }
            case DIRECTORY: {
                if (train) {
                    File dir = new File(this.train, this.getPathLabel(path));
                    File name = new File(dir, file.getName());
                    return name.getAbsolutePath();
                }
                File dir = new File(this.test, this.getPathLabel(path));
                File name = new File(dir, file.getName());
                return name.getAbsolutePath();
            }
        }
        throw new IllegalStateException("Illegal labeling type ");
    }

    public String getPathLabel(String path) {
        return new File(path).getParentFile().getName();
    }

    public String getNameLabel(String path) {
        int startOfFormat = path.lastIndexOf(46);
        if (startOfFormat < 0) {
            throw new IllegalStateException("Illegal path; no format found");
        }
        StringBuffer label = new StringBuffer();
        while (path.charAt(startOfFormat) != '-') {
            label.append(path.charAt(startOfFormat));
            --startOfFormat;
        }
        if (startOfFormat < 0) {
            throw new IllegalStateException("Illegal path; no - found. A dash is used to inidicate a lbale.");
        }
        return label.reverse().toString();
    }

    public int getNumExamplesTotal() {
        return this.numExamplesTotal;
    }

    public int getNumExamplesToTrainOn() {
        return this.numExamplesToTrainOn;
    }

    public int getNumTestExamples() {
        return this.numTestExamples;
    }

    public File getTest() {
        return this.test;
    }

    public File getTrain() {
        return this.train;
    }

    public static enum LabelingType {
        NAME,
        DIRECTORY;

    }
}

