/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.inputs;

import java.beans.ConstructorProperties;
import java.io.Serializable;

public abstract class InputType
implements Serializable {
    public abstract Type getType();

    public static InputType feedForward(int size) {
        return new InputTypeFeedForward(size);
    }

    public static InputType recurrent(int size) {
        return new InputTypeRecurrent(size);
    }

    public static InputType convolutional(int height, int width, int depth) {
        return new InputTypeConvolutional(height, width, depth);
    }

    public static class InputTypeConvolutional
    extends InputType {
        private int height;
        private int width;
        private int depth;

        @Override
        public Type getType() {
            return Type.CNN;
        }

        @ConstructorProperties(value={"height", "width", "depth"})
        public InputTypeConvolutional(int height, int width, int depth) {
            this.height = height;
            this.width = width;
            this.depth = depth;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        public int getDepth() {
            return this.depth;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public void setDepth(int depth) {
            this.depth = depth;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InputTypeConvolutional)) {
                return false;
            }
            InputTypeConvolutional other = (InputTypeConvolutional)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getHeight() != other.getHeight()) {
                return false;
            }
            if (this.getWidth() != other.getWidth()) {
                return false;
            }
            return this.getDepth() == other.getDepth();
        }

        protected boolean canEqual(Object other) {
            return other instanceof InputTypeConvolutional;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getHeight();
            result = result * 59 + this.getWidth();
            result = result * 59 + this.getDepth();
            return result;
        }

        public String toString() {
            return "InputType.InputTypeConvolutional(height=" + this.getHeight() + ", width=" + this.getWidth() + ", depth=" + this.getDepth() + ")";
        }
    }

    public static class InputTypeRecurrent
    extends InputType {
        private int size;

        @Override
        public Type getType() {
            return Type.RNN;
        }

        @ConstructorProperties(value={"size"})
        public InputTypeRecurrent(int size) {
            this.size = size;
        }

        public int getSize() {
            return this.size;
        }
    }

    public static class InputTypeFeedForward
    extends InputType {
        private int size;

        @Override
        public Type getType() {
            return Type.FF;
        }

        @ConstructorProperties(value={"size"})
        public InputTypeFeedForward(int size) {
            this.size = size;
        }

        public int getSize() {
            return this.size;
        }
    }

    public static enum Type {
        FF,
        RNN,
        CNN;

    }
}

