/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.graph.rnn;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.deeplearning4j.nn.conf.graph.GraphVertex;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.inputs.InvalidInputTypeException;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.nd4j.linalg.api.ndarray.INDArray;

public class DuplicateToTimeSeriesVertex
extends GraphVertex {
    private String inputName;

    public DuplicateToTimeSeriesVertex(@JsonProperty(value="inputName") String inputName) {
        this.inputName = inputName;
    }

    @Override
    public GraphVertex clone() {
        return new DuplicateToTimeSeriesVertex(this.inputName);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof DuplicateToTimeSeriesVertex)) {
            return false;
        }
        DuplicateToTimeSeriesVertex d = (DuplicateToTimeSeriesVertex)o;
        if (this.inputName == null && d.inputName != null || this.inputName != null && d.inputName == null) {
            return false;
        }
        return this.inputName == null || this.inputName.equals(d.inputName);
    }

    @Override
    public int hashCode() {
        return 0x1FE08025 ^ (this.inputName != null ? this.inputName.hashCode() : 0);
    }

    @Override
    public int numParams(boolean backprop) {
        return 0;
    }

    @Override
    public org.deeplearning4j.nn.graph.vertex.GraphVertex instantiate(ComputationGraph graph, String name, int idx, INDArray paramsView) {
        return new org.deeplearning4j.nn.graph.vertex.impl.rnn.DuplicateToTimeSeriesVertex(graph, name, idx, this.inputName);
    }

    @Override
    public InputType getOutputType(InputType ... vertexInputs) throws InvalidInputTypeException {
        if (vertexInputs.length != 1) {
            throw new InvalidInputTypeException("Invalid input type: cannot duplicate more than 1 input");
        }
        if (vertexInputs[0].getType() != InputType.Type.FF) {
            throw new InvalidInputTypeException("Invalid input type: cannot duplicate to time series non feed forward input (got: " + vertexInputs[0] + ")");
        }
        return InputType.recurrent(((InputType.InputTypeFeedForward)vertexInputs[0]).getSize());
    }

    public String getInputName() {
        return this.inputName;
    }

    public void setInputName(String inputName) {
        this.inputName = inputName;
    }

    public String toString() {
        return "DuplicateToTimeSeriesVertex(inputName=" + this.getInputName() + ")";
    }
}

