/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.earlystopping.saver;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.deeplearning4j.earlystopping.EarlyStoppingModelSaver;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.updater.graph.ComputationGraphUpdater;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class LocalFileGraphSaver
implements EarlyStoppingModelSaver<ComputationGraph> {
    private static final String bestFileNameConf = "bestGraphConf.json";
    private static final String bestFileNameParam = "bestGraphParams.bin";
    private static final String bestFileNameUpdater = "bestGraphUpdater.bin";
    private static final String latestFileNameConf = "latestGraphConf.json";
    private static final String latestFileNameParam = "latestGraphParams.bin";
    private static final String latestFileNameUpdater = "latestGraphUpdater.bin";
    private String directory;
    private Charset encoding;

    public LocalFileGraphSaver(String directory) {
        this(directory, Charset.defaultCharset());
    }

    public LocalFileGraphSaver(String directory, Charset encoding) {
        this.directory = directory;
        this.encoding = encoding;
    }

    @Override
    public void saveBestModel(ComputationGraph net, double score) throws IOException {
        String confOut = FilenameUtils.concat((String)this.directory, (String)bestFileNameConf);
        String paramOut = FilenameUtils.concat((String)this.directory, (String)bestFileNameParam);
        String updaterOut = FilenameUtils.concat((String)this.directory, (String)bestFileNameUpdater);
        this.save(net, confOut, paramOut, updaterOut);
    }

    @Override
    public void saveLatestModel(ComputationGraph net, double score) throws IOException {
        String confOut = FilenameUtils.concat((String)this.directory, (String)latestFileNameConf);
        String paramOut = FilenameUtils.concat((String)this.directory, (String)latestFileNameParam);
        String updaterOut = FilenameUtils.concat((String)this.directory, (String)latestFileNameUpdater);
        this.save(net, confOut, paramOut, updaterOut);
    }

    private void save(ComputationGraph net, String confOut, String paramOut, String updaterOut) throws IOException {
        String confJSON = net.getConfiguration().toJson();
        INDArray params = net.params();
        ComputationGraphUpdater updater = net.getUpdater();
        FileUtils.writeStringToFile((File)new File(confOut), (String)confJSON, (Charset)this.encoding);
        try (DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(Files.newOutputStream(Paths.get(paramOut, new String[0]), new OpenOption[0])));){
            Nd4j.write((INDArray)params, (DataOutputStream)dos);
        }
        var9_9 = null;
        try (ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(new File(updaterOut))));){
            oos.writeObject(updater);
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
    }

    @Override
    public ComputationGraph getBestModel() throws IOException {
        String confOut = FilenameUtils.concat((String)this.directory, (String)bestFileNameConf);
        String paramOut = FilenameUtils.concat((String)this.directory, (String)bestFileNameParam);
        String updaterOut = FilenameUtils.concat((String)this.directory, (String)bestFileNameUpdater);
        return this.load(confOut, paramOut, updaterOut);
    }

    @Override
    public ComputationGraph getLatestModel() throws IOException {
        String confOut = FilenameUtils.concat((String)this.directory, (String)bestFileNameConf);
        String paramOut = FilenameUtils.concat((String)this.directory, (String)bestFileNameParam);
        String updaterOut = FilenameUtils.concat((String)this.directory, (String)bestFileNameUpdater);
        return this.load(confOut, paramOut, updaterOut);
    }

    private ComputationGraph load(String confOut, String paramOut, String updaterOut) throws IOException {
        ComputationGraphUpdater updater;
        INDArray params;
        String confJSON = FileUtils.readFileToString((File)new File(confOut), (Charset)this.encoding);
        try (DataInputStream dis = new DataInputStream(new BufferedInputStream(Files.newInputStream(Paths.get(paramOut, new String[0]), new OpenOption[0])));){
            params = Nd4j.read((DataInputStream)dis);
        }
        try {
            var8_7 = null;
            try (ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(new File(updaterOut))));){
                updater = (ComputationGraphUpdater)ois.readObject();
            }
            catch (Throwable throwable) {
                var8_7 = throwable;
                throw throwable;
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        ComputationGraphConfiguration conf = ComputationGraphConfiguration.fromJson(confJSON);
        ComputationGraph net = new ComputationGraph(conf);
        net.init();
        net.setParams(params);
        net.setUpdater(updater);
        return net;
    }

    public String toString() {
        return "LocalFileGraphSaver(dir=" + this.directory + ")";
    }
}

