/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.iterator.impl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.bytedeco.javacpp.opencv_core;
import org.canova.image.loader.CifarLoader;
import org.deeplearning4j.datasets.canova.RecordReaderDataSetIterator;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.api.DataSet;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.FeatureUtil;

public class CifarDataSetIterator
extends RecordReaderDataSetIterator {
    protected static int height = 32;
    protected static int width = 32;
    protected static int channels = 3;
    protected static int numPixels = 3073;
    protected static CifarLoader loader;
    protected static InputStream inputStream;
    protected int totalExamples;
    protected int numExamples;
    protected int exampleCount;

    public CifarDataSetIterator(int batchSize, int numExamples) {
        super(null, batchSize, 1, 10);
        this.numExamples = this.totalExamples = 100000;
        this.exampleCount = 0;
        loader = new CifarLoader();
        inputStream = loader.getInputStream();
        this.numExamples = numExamples > this.totalExamples ? this.totalExamples : numExamples;
    }

    public CifarDataSetIterator(int batchSize, int numExamples, String version) {
        super(null, batchSize, 1, 10);
        this.numExamples = this.totalExamples = 100000;
        this.exampleCount = 0;
        loader = new CifarLoader(version);
        inputStream = loader.getInputStream();
        this.numExamples = numExamples > this.totalExamples ? this.totalExamples : numExamples;
    }

    public CifarDataSetIterator(int batchSize, int numExamples, int[] imgDim) {
        super(null, batchSize, 1, 10);
        this.numExamples = this.totalExamples = 100000;
        this.exampleCount = 0;
        loader = new CifarLoader(imgDim[0], imgDim[1], imgDim[2]);
        inputStream = loader.getInputStream();
        this.numExamples = numExamples > this.totalExamples ? this.totalExamples : numExamples;
    }

    public CifarDataSetIterator(int batchSize, int numExamples, int[] imgDim, String version) {
        super(null, batchSize, 1, 10);
        this.numExamples = this.totalExamples = 100000;
        this.exampleCount = 0;
        loader = new CifarLoader(imgDim[0], imgDim[1], imgDim[2], version);
        inputStream = loader.getInputStream();
        this.numExamples = numExamples > this.totalExamples ? this.totalExamples : numExamples;
    }

    public CifarDataSetIterator(int batchSize, int numExamples, int[] imgDim, int numCategories) {
        super(null, batchSize, 1, numCategories);
        this.numExamples = this.totalExamples = 100000;
        this.exampleCount = 0;
        loader = new CifarLoader(imgDim[0], imgDim[1], imgDim[2]);
        inputStream = loader.getInputStream();
        this.numExamples = numExamples > this.totalExamples ? this.totalExamples : numExamples;
    }

    public CifarDataSetIterator(int batchSize, int numExamples, int[] imgDim, int numCategories, String version) {
        super(null, batchSize, 1, numCategories);
        this.numExamples = this.totalExamples = 100000;
        this.exampleCount = 0;
        loader = new CifarLoader(imgDim[0], imgDim[1], imgDim[2], version);
        inputStream = loader.getInputStream();
        this.numExamples = numExamples > this.totalExamples ? this.totalExamples : numExamples;
    }

    public CifarDataSetIterator(int batchSize, int numExamples, int numCategories) {
        super(null, batchSize, 1, numCategories);
        this.numExamples = this.totalExamples = 100000;
        this.exampleCount = 0;
        loader = new CifarLoader();
        inputStream = loader.getInputStream();
        this.numExamples = numExamples > this.totalExamples ? this.totalExamples : numExamples;
    }

    public CifarDataSetIterator(int batchSize, int[] imgDim) {
        super(null, batchSize, 1, 10);
        this.numExamples = this.totalExamples = 100000;
        this.exampleCount = 0;
        loader = new CifarLoader(imgDim[0], imgDim[1], imgDim[2]);
        inputStream = loader.getInputStream();
    }

    @Override
    public org.nd4j.linalg.dataset.DataSet next(int num) {
        org.nd4j.linalg.dataset.DataSet ret;
        if (this.useCurrent) {
            this.useCurrent = false;
            if (this.preProcessor != null) {
                this.preProcessor.preProcess((DataSet)this.last);
            }
            return this.last;
        }
        byte[] byteFeature = new byte[numPixels];
        ArrayList<org.nd4j.linalg.dataset.DataSet> dataSets = new ArrayList<org.nd4j.linalg.dataset.DataSet>();
        INDArray label = null;
        opencv_core.Mat image = new opencv_core.Mat(height, width, opencv_core.CV_8UC((int)channels));
        ByteBuffer imageData = (ByteBuffer)image.createBuffer();
        try {
            for (int batchNumCount = 0; inputStream.read(byteFeature) != -1 && batchNumCount != num; ++batchNumCount) {
                label = FeatureUtil.toOutcomeVector((int)byteFeature[0], (int)this.numPossibleLabels);
                for (int i = 0; i < height * width; ++i) {
                    imageData.put(3 * i, byteFeature[i + 1 + 2 * height * width]);
                    imageData.put(3 * i + 1, byteFeature[i + 1 + height * width]);
                    imageData.put(3 * i + 2, byteFeature[i + 1]);
                }
                dataSets.add(new org.nd4j.linalg.dataset.DataSet(loader.asRowVector(image), label));
            }
            this.exampleCount += this.batchSize;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ArrayList<INDArray> inputs = new ArrayList<INDArray>();
        ArrayList<INDArray> labels = new ArrayList<INDArray>();
        for (org.nd4j.linalg.dataset.DataSet data : dataSets) {
            inputs.add(data.getFeatureMatrix());
            labels.add(data.getLabels());
        }
        if (inputs.isEmpty() || this.maxNumBatches > -1 && this.batchNum >= this.maxNumBatches) {
            this.notOvershot = false;
            return this.last;
        }
        this.last = ret = new org.nd4j.linalg.dataset.DataSet(Nd4j.vstack((INDArray[])inputs.toArray(new INDArray[0])), Nd4j.vstack((INDArray[])labels.toArray(new INDArray[0])));
        if (this.preProcessor != null) {
            this.preProcessor.preProcess((DataSet)ret);
        }
        if (loader.getLabels() != null) {
            ret.setLabelNames(loader.getLabels());
        }
        return ret;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.exampleCount < this.numExamples;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public int totalExamples() {
        return this.totalExamples;
    }

    @Override
    public void reset() {
        inputStream = loader.getInputStream();
    }

    @Override
    public List<String> getLabels() {
        return loader.getLabels();
    }

    static {
        inputStream = null;
    }
}

