/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.iterator;

import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.deeplearning4j.datasets.iterator.DataSetIterator;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;

public class AsyncDataSetIterator
implements DataSetIterator {
    private final DataSetIterator baseIterator;
    private final BlockingQueue<DataSet> blockingQueue;
    private Thread thread;
    private IteratorRunnable runnable;

    public AsyncDataSetIterator(DataSetIterator baseIterator) {
        this(baseIterator, 1);
    }

    public AsyncDataSetIterator(DataSetIterator baseIterator, int queueSize) {
        if (queueSize <= 0) {
            throw new IllegalArgumentException("Queue size must be > 0");
        }
        this.baseIterator = baseIterator;
        this.blockingQueue = new LinkedBlockingDeque<DataSet>(queueSize);
        this.runnable = new IteratorRunnable();
        this.thread = new Thread(this.runnable);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public DataSet next(int num) {
        throw new UnsupportedOperationException("Next(int) not supported for AsyncDataSetIterator");
    }

    public int totalExamples() {
        return this.baseIterator.totalExamples();
    }

    public int inputColumns() {
        return this.baseIterator.inputColumns();
    }

    public int totalOutcomes() {
        return this.baseIterator.totalOutcomes();
    }

    public synchronized void reset() {
        this.runnable.killRunnable = true;
        if (this.runnable.isAlive) {
            this.thread.interrupt();
        }
        try {
            this.runnable.runCompletedSemaphore.tryAcquire(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.blockingQueue.clear();
        this.baseIterator.reset();
        this.runnable = new IteratorRunnable();
        this.thread = new Thread(this.runnable);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public int batch() {
        return this.baseIterator.batch();
    }

    public int cursor() {
        return this.baseIterator.cursor();
    }

    public int numExamples() {
        return this.baseIterator.numExamples();
    }

    public void setPreProcessor(DataSetPreProcessor preProcessor) {
        this.baseIterator.setPreProcessor(preProcessor);
    }

    public List<String> getLabels() {
        return this.baseIterator.getLabels();
    }

    @Override
    public synchronized boolean hasNext() {
        if (!this.blockingQueue.isEmpty()) {
            return true;
        }
        if (this.runnable.isAlive) {
            return true;
        }
        if (!this.runnable.killRunnable && this.runnable.exception != null) {
            throw this.runnable.exception;
        }
        return !this.blockingQueue.isEmpty();
    }

    @Override
    public synchronized DataSet next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.runnable.exception != null) {
            throw this.runnable.exception;
        }
        if (!this.blockingQueue.isEmpty()) {
            return (DataSet)this.blockingQueue.poll();
        }
        try {
            while (this.runnable.exception == null) {
                DataSet ds = this.blockingQueue.poll(5L, TimeUnit.SECONDS);
                if (ds != null) {
                    return ds;
                }
                if (!this.runnable.killRunnable) continue;
                throw new ConcurrentModificationException("Reset while next() is waiting for element?");
            }
            throw this.runnable.exception;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void shutdown() {
        if (this.thread.isAlive()) {
            this.runnable.killRunnable = true;
            this.thread.interrupt();
        }
    }

    @Override
    public void remove() {
    }

    private class IteratorRunnable
    implements Runnable {
        private boolean killRunnable = false;
        private boolean isAlive = true;
        private RuntimeException exception;
        private Semaphore runCompletedSemaphore = new Semaphore(0);

        private IteratorRunnable() {
        }

        @Override
        public void run() {
            try {
                while (!this.killRunnable && AsyncDataSetIterator.this.baseIterator.hasNext()) {
                    AsyncDataSetIterator.this.blockingQueue.put(AsyncDataSetIterator.this.baseIterator.next());
                }
            }
            catch (InterruptedException e) {
                if (this.killRunnable) {
                    return;
                }
                this.exception = new RuntimeException("Runnable interrupted unexpectedly", e);
            }
            catch (RuntimeException e) {
                this.exception = e;
            }
            finally {
                this.isAlive = false;
                this.runCompletedSemaphore.release();
            }
        }
    }
}

