/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.updater;

import java.util.HashMap;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.Updater;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.Gradient;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.learning.GradientUpdater;
import org.nd4j.linalg.ops.transforms.Transforms;

public abstract class BaseUpdater
implements Updater {
    protected Map<String, GradientUpdater> updaterForVariable = new HashMap<String, GradientUpdater>();

    @Override
    public void update(Layer layer, Gradient gradient, int iteration) {
        for (Map.Entry<String, INDArray> gradientPair : gradient.gradientForVariable().entrySet()) {
            GradientUpdater updater = this.init(gradientPair.getKey(), gradientPair.getValue(), layer);
            INDArray gradient2 = updater.getGradient(gradientPair.getValue(), iteration);
            this.postApply(layer, gradient2, gradientPair.getKey());
            gradient.setGradientFor(gradientPair.getKey(), gradient2);
        }
    }

    public void postApply(Layer layer, INDArray gradient, String param) {
        NeuralNetConfiguration conf = layer.conf();
        INDArray params = layer.getParam(param);
        if (conf.isUseRegularization() && conf.getL2() > 0.0 && !param.equals("b")) {
            gradient.addi(params.mul((Number)conf.getL2()));
        }
        if (conf.isUseRegularization() && conf.getL1() > 0.0 && !param.equals("b")) {
            gradient.addi(Transforms.sign((INDArray)params).muli((Number)conf.getL1()));
        }
        if (conf.isMiniBatch()) {
            gradient.divi((Number)layer.getInputMiniBatchSize());
        }
        if (conf.isConstrainGradientToUnitNorm()) {
            gradient.divi(gradient.norm2(new int[]{Integer.MAX_VALUE}));
        }
    }

    public abstract void init();

    public abstract GradientUpdater init(String var1, INDArray var2, Layer var3);
}

