/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers;

import java.io.Serializable;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.berkeley.Triple;
import org.deeplearning4j.eval.Evaluation;
import org.deeplearning4j.nn.api.Classifier;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.BaseLayer;
import org.deeplearning4j.optimize.Solver;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.LossFunction;
import org.nd4j.linalg.api.ops.impl.transforms.SoftMax;
import org.nd4j.linalg.dataset.api.DataSet;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.lossfunctions.LossCalculation;
import org.nd4j.linalg.lossfunctions.LossFunctions;
import org.nd4j.linalg.ops.transforms.Transforms;
import org.nd4j.linalg.util.FeatureUtil;
import org.nd4j.linalg.util.LinAlgExceptions;

public abstract class BaseOutputLayer<LayerConfT extends org.deeplearning4j.nn.conf.layers.BaseOutputLayer>
extends BaseLayer<LayerConfT>
implements Serializable,
Classifier {
    protected INDArray labels;
    private transient Solver solver;
    private double fullNetworkL1;
    private double fullNetworkL2;

    public BaseOutputLayer(NeuralNetConfiguration conf) {
        super(conf);
    }

    public BaseOutputLayer(NeuralNetConfiguration conf, INDArray input) {
        super(conf, input);
    }

    public double computeScore(double fullNetworkL1, double fullNetworkL2) {
        if (this.input == null || this.labels == null) {
            throw new IllegalStateException("Cannot calculate score without input and labels");
        }
        this.fullNetworkL1 = fullNetworkL1;
        this.fullNetworkL2 = fullNetworkL2;
        this.setScoreWithZ(this.output2d(this.input));
        return this.score;
    }

    @Override
    public void computeGradientAndScore() {
        if (this.input == null || this.labels == null) {
            return;
        }
        INDArray z = this.preOutput2d(this.input, true);
        Triple<Gradient, INDArray, INDArray> triple = this.getGradientsAndDelta(z);
        this.gradient = triple.getFirst();
        this.setScoreWithZ(triple.getThird());
    }

    @Override
    protected void setScoreWithZ(INDArray z) {
        if (((org.deeplearning4j.nn.conf.layers.BaseOutputLayer)this.layerConf()).getLossFunction() == LossFunctions.LossFunction.CUSTOM) {
            LossFunction create = Nd4j.getOpFactory().createLossFunction(((org.deeplearning4j.nn.conf.layers.BaseOutputLayer)this.layerConf()).getCustomLossFunction(), this.input, z);
            create.exec();
            this.score = create.currentResult().doubleValue();
        } else {
            this.score = LossCalculation.builder().l1(this.fullNetworkL1).l2(this.fullNetworkL2).labels(this.getLabels2d()).z(z).lossFunction(((org.deeplearning4j.nn.conf.layers.BaseOutputLayer)this.layerConf()).getLossFunction()).miniBatch(this.conf.isMiniBatch()).miniBatchSize(this.getInputMiniBatchSize()).useRegularization(this.conf.isUseRegularization()).build().score();
        }
    }

    @Override
    public Pair<Gradient, Double> gradientAndScore() {
        return new Pair<Gradient, Double>(this.gradient(), this.score());
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon) {
        Triple<Gradient, INDArray, INDArray> triple = this.getGradientsAndDelta(this.preOutput2d(this.input, true));
        INDArray delta = triple.getSecond();
        INDArray epsilonNext = ((INDArray)this.params.get("W")).mmul(delta.transpose()).transpose();
        return new Pair<Gradient, INDArray>(triple.getFirst(), epsilonNext);
    }

    @Override
    public Gradient gradient() {
        LinAlgExceptions.assertRows((INDArray)this.input, (INDArray)this.getLabels2d());
        return this.gradient;
    }

    private Triple<Gradient, INDArray, INDArray> getGradientsAndDelta(INDArray preOut) {
        INDArray output = Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createTransform(this.conf().getLayer().getActivationFunction(), preOut.dup()));
        INDArray outSubLabels = output.sub(this.getLabels2d());
        DefaultGradient gradient = new DefaultGradient();
        switch (((org.deeplearning4j.nn.conf.layers.BaseOutputLayer)this.layerConf()).getLossFunction()) {
            case MCXENT: {
                gradient.gradientForVariable().put("W", this.input.transpose().mmul(outSubLabels));
                gradient.gradientForVariable().put("b", outSubLabels.sum(new int[]{0}));
                return new Triple<Gradient, INDArray, INDArray>(gradient, outSubLabels, output);
            }
            case XENT: {
                gradient.gradientForVariable().put("W", this.input.transpose().mmul(outSubLabels.div(output.mul(output.rsub((Number)1)))));
                gradient.gradientForVariable().put("b", outSubLabels.sum(new int[]{0}));
                return new Triple<Gradient, INDArray, INDArray>(gradient, outSubLabels, output);
            }
            case MSE: {
                INDArray delta = outSubLabels.mul(this.derivativeActivation(preOut));
                gradient.gradientForVariable().put("W", this.input.transpose().mmul(delta));
                gradient.gradientForVariable().put("b", delta.sum(new int[]{0}));
                return new Triple<Gradient, INDArray, INDArray>(gradient, delta, output);
            }
            case EXPLL: {
                gradient.gradientForVariable().put("W", this.input.transpose().mmul(this.labels.rsub((Number)1).divi(output)));
                gradient.gradientForVariable().put("b", outSubLabels.sum(new int[]{0}));
                return new Triple<Gradient, INDArray, INDArray>(gradient, outSubLabels, output);
            }
            case RMSE_XENT: {
                INDArray squaredrmseXentDiff = Transforms.pow((INDArray)outSubLabels, (Number)2.0);
                INDArray sqrt = Transforms.sqrt((INDArray)squaredrmseXentDiff);
                gradient.gradientForVariable().put("W", this.input.transpose().mmul(sqrt));
                gradient.gradientForVariable().put("b", outSubLabels.sum(new int[]{0}));
                return new Triple<Gradient, INDArray, INDArray>(gradient, outSubLabels, output);
            }
            case SQUARED_LOSS: {
                gradient.gradientForVariable().put("W", this.input.transpose().mmul(this.input.transpose().mmul(Transforms.pow((INDArray)outSubLabels, (Number)2))));
                gradient.gradientForVariable().put("b", outSubLabels.sum(new int[]{0}));
                return new Triple<Gradient, INDArray, INDArray>(gradient, outSubLabels, output);
            }
            case NEGATIVELOGLIKELIHOOD: {
                gradient.gradientForVariable().put("W", this.input.transpose().mmul(outSubLabels));
                gradient.gradientForVariable().put("b", outSubLabels.sum(new int[]{0}));
                return new Triple<Gradient, INDArray, INDArray>(gradient, outSubLabels, output);
            }
        }
        throw new IllegalStateException("Invalid loss function: " + ((org.deeplearning4j.nn.conf.layers.BaseOutputLayer)this.layerConf()).getLossFunction());
    }

    @Override
    public INDArray activate(INDArray input, boolean training) {
        this.setInput(input, training);
        return this.output(training);
    }

    @Override
    public INDArray activate(INDArray input) {
        this.setInput(input);
        return this.output(true);
    }

    @Override
    public INDArray activate() {
        return this.output(false);
    }

    public INDArray output(INDArray input, boolean training) {
        this.setInput(input, training);
        return this.output(training);
    }

    public INDArray output(INDArray input) {
        this.setInput(input, false);
        return this.output(false);
    }

    public INDArray output(boolean training) {
        if (this.input == null) {
            throw new IllegalArgumentException("No null input allowed");
        }
        INDArray preOutput = this.preOutput2d(this.input, training);
        if (this.conf.getLayer().getActivationFunction().equals("softmax")) {
            SoftMax softMax = new SoftMax(preOutput);
            softMax.exec(new int[]{1});
            return softMax.z();
        }
        if (training) {
            this.applyDropOutIfNecessary(this.input(), training);
        }
        return super.activate(true);
    }

    @Override
    public double f1Score(DataSet data) {
        return this.f1Score(data.getFeatureMatrix(), data.getLabels());
    }

    @Override
    public double f1Score(INDArray examples, INDArray labels) {
        Evaluation eval = new Evaluation();
        eval.eval(labels, this.labelProbabilities(examples));
        return eval.f1();
    }

    @Override
    public int numLabels() {
        return this.labels.size(1);
    }

    @Override
    public void fit(DataSetIterator iter) {
        while (iter.hasNext()) {
            this.fit((DataSet)iter.next());
        }
    }

    @Override
    public int[] predict(INDArray input) {
        INDArray output = this.output(input);
        int[] ret = new int[input.rows()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = Nd4j.getBlasWrapper().iamax(output.getRow(i));
        }
        return ret;
    }

    @Override
    public INDArray labelProbabilities(INDArray examples) {
        return this.output(examples);
    }

    @Override
    public void fit(INDArray input, INDArray labels) {
        this.setInput(input);
        this.setLabels(labels);
        this.applyDropOutIfNecessary(this.input, true);
        if (this.solver == null) {
            this.solver = new Solver.Builder().configure(this.conf()).listeners(this.getListeners()).model(this).build();
        }
        this.solver.optimize();
    }

    @Override
    public void fit(DataSet data) {
        this.fit(data.getFeatureMatrix(), data.getLabels());
    }

    @Override
    public void fit(INDArray examples, int[] labels) {
        INDArray outcomeMatrix = FeatureUtil.toOutcomeMatrix((int[])labels, (int)this.numLabels());
        this.fit(examples, outcomeMatrix);
    }

    @Override
    public void clear() {
        super.clear();
        if (this.labels != null) {
            this.labels.data().destroy();
            this.labels = null;
        }
        this.solver = null;
    }

    @Override
    public void setParams(INDArray params) {
        INDArray wParams = params.get(new INDArrayIndex[]{NDArrayIndex.point((int)0), NDArrayIndex.interval((int)0, (int)(((org.deeplearning4j.nn.conf.layers.BaseOutputLayer)this.layerConf()).getNIn() * ((org.deeplearning4j.nn.conf.layers.BaseOutputLayer)this.layerConf()).getNOut()))});
        INDArray W = this.getParam("W");
        W.assign(wParams);
        INDArray bias = this.getParam("b");
        int biasBegin = params.length() - bias.length();
        int biasEnd = params.length();
        INDArray biasAssign = params.get(new INDArrayIndex[]{NDArrayIndex.point((int)0), NDArrayIndex.interval((int)biasBegin, (int)biasEnd)});
        bias.assign(biasAssign);
    }

    @Override
    public void fit(INDArray data) {
    }

    @Override
    public void iterate(INDArray input) {
        throw new UnsupportedOperationException();
    }

    public INDArray getLabels() {
        return this.labels;
    }

    public void setLabels(INDArray labels) {
        this.labels = labels;
    }

    protected INDArray preOutput2d(INDArray input, boolean training) {
        return this.preOutput(input, training);
    }

    protected INDArray output2d(INDArray input) {
        return this.output(input);
    }

    protected INDArray getLabels2d() {
        return this.labels;
    }
}

