/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.nd4j.linalg.convolution.Convolution;

public class ConvolutionLayer
extends FeedForwardLayer {
    protected Convolution.Type convolutionType;
    protected int[] kernelSize;
    protected int[] stride;
    protected int[] padding;

    private ConvolutionLayer(Builder builder) {
        super(builder);
        this.convolutionType = builder.convolutionType;
        if (builder.kernelSize.length != 2) {
            throw new IllegalArgumentException("Kernel size of should be rows x columns (a 2d array)");
        }
        this.kernelSize = builder.kernelSize;
        if (builder.stride.length != 2) {
            throw new IllegalArgumentException("Invalid stride, must be length 2");
        }
        this.stride = builder.stride;
        this.padding = builder.padding;
    }

    @Override
    public ConvolutionLayer clone() {
        ConvolutionLayer clone = (ConvolutionLayer)super.clone();
        if (clone.kernelSize != null) {
            clone.kernelSize = (int[])clone.kernelSize.clone();
        }
        if (clone.stride != null) {
            clone.stride = (int[])clone.stride.clone();
        }
        if (clone.padding != null) {
            clone.padding = (int[])clone.padding.clone();
        }
        return clone;
    }

    public Convolution.Type getConvolutionType() {
        return this.convolutionType;
    }

    public int[] getKernelSize() {
        return this.kernelSize;
    }

    public int[] getStride() {
        return this.stride;
    }

    public int[] getPadding() {
        return this.padding;
    }

    public void setConvolutionType(Convolution.Type convolutionType) {
        this.convolutionType = convolutionType;
    }

    public void setKernelSize(int[] kernelSize) {
        this.kernelSize = kernelSize;
    }

    public void setStride(int[] stride) {
        this.stride = stride;
    }

    public void setPadding(int[] padding) {
        this.padding = padding;
    }

    public ConvolutionLayer() {
    }

    @Override
    public String toString() {
        return "ConvolutionLayer(super=" + super.toString() + ", convolutionType=" + this.getConvolutionType() + ", kernelSize=" + Arrays.toString(this.getKernelSize()) + ", stride=" + Arrays.toString(this.getStride()) + ", padding=" + Arrays.toString(this.getPadding()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConvolutionLayer)) {
            return false;
        }
        ConvolutionLayer other = (ConvolutionLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Convolution.Type this$convolutionType = this.getConvolutionType();
        Convolution.Type other$convolutionType = other.getConvolutionType();
        if (this$convolutionType == null ? other$convolutionType != null : !this$convolutionType.equals(other$convolutionType)) {
            return false;
        }
        if (!Arrays.equals(this.getKernelSize(), other.getKernelSize())) {
            return false;
        }
        if (!Arrays.equals(this.getStride(), other.getStride())) {
            return false;
        }
        return Arrays.equals(this.getPadding(), other.getPadding());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ConvolutionLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Convolution.Type $convolutionType = this.getConvolutionType();
        result = result * 59 + ($convolutionType == null ? 0 : $convolutionType.hashCode());
        result = result * 59 + Arrays.hashCode(this.getKernelSize());
        result = result * 59 + Arrays.hashCode(this.getStride());
        result = result * 59 + Arrays.hashCode(this.getPadding());
        return result;
    }

    public static class Builder
    extends FeedForwardLayer.Builder<Builder> {
        private Convolution.Type convolutionType = Convolution.Type.VALID;
        private int[] kernelSize = new int[]{5, 5};
        private int[] stride = new int[]{2, 2};
        private int[] padding = new int[]{0, 0};

        public Builder(int[] kernelSize, int[] stride, int[] padding) {
            this.kernelSize = kernelSize;
            this.stride = stride;
            this.padding = padding;
        }

        public Builder(int[] kernelSize, int[] stride) {
            this.kernelSize = kernelSize;
            this.stride = stride;
        }

        public Builder(int ... kernelSize) {
            this.kernelSize = kernelSize;
        }

        public Builder() {
        }

        public Builder convolutionType(Convolution.Type convolutionType) {
            this.convolutionType = convolutionType;
            return this;
        }

        public Builder kernelSize(int ... kernelSize) {
            this.kernelSize = kernelSize;
            return this;
        }

        public Builder stride(int ... stride) {
            this.stride = stride;
            return this;
        }

        public Builder padding(int ... padding) {
            this.padding = padding;
            return this;
        }

        @Override
        public ConvolutionLayer build() {
            return new ConvolutionLayer(this);
        }

        @ConstructorProperties(value={"convolutionType", "kernelSize", "stride", "padding"})
        public Builder(Convolution.Type convolutionType, int[] kernelSize, int[] stride, int[] padding) {
            this.convolutionType = convolutionType;
            this.kernelSize = kernelSize;
            this.stride = stride;
            this.padding = padding;
        }
    }

    public static enum PoolingType {
        FULL,
        VALID,
        SAME;

    }
}

