/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.clustering.cluster;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.deeplearning4j.clustering.cluster.Point;
import org.nd4j.linalg.factory.Nd4j;

public class Cluster {
    private String id = UUID.randomUUID().toString();
    private String label;
    private Point center;
    private List<Point> points = new ArrayList<Point>();
    private String distanceFunction;

    public Cluster() {
    }

    public Cluster(Point center, String distanceFunction) {
        this.distanceFunction = distanceFunction;
        this.setCenter(center);
    }

    public double getDistanceToCenter(Point point) {
        return Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createAccum(this.distanceFunction, this.center.getArray(), point.getArray())).currentResult().doubleValue();
    }

    public void addPoint(Point point) {
        this.addPoint(point, true);
    }

    public void addPoint(Point point, boolean moveClusterCenter) {
        if (moveClusterCenter) {
            this.center.getArray().muli((Number)this.points.size()).addi(point.getArray()).divi((Number)(this.points.size() + 1));
        }
        this.getPoints().add(point);
    }

    public void removePoints() {
        if (this.getPoints() != null) {
            this.getPoints().clear();
        }
    }

    public boolean isEmpty() {
        return this.points == null || this.points.size() == 0;
    }

    public Point getPoint(String id) {
        for (Point point : this.points) {
            if (!id.equals(point.getId())) continue;
            return point;
        }
        return null;
    }

    public Point removePoint(String id) {
        Point removePoint = null;
        for (Point point : this.points) {
            if (!id.equals(point.getId())) continue;
            removePoint = point;
        }
        if (removePoint != null) {
            this.points.remove(removePoint);
        }
        return removePoint;
    }

    public Point getCenter() {
        return this.center;
    }

    public void setCenter(Point center) {
        this.center = center;
    }

    public List<Point> getPoints() {
        return this.points;
    }

    public void setPoints(List<Point> points) {
        this.points = points;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }
}

