/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.plot.iterationlistener;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.optimize.api.IterationListener;
import org.deeplearning4j.plot.PlotFilters;
import org.deeplearning4j.util.ImageLoader;
import org.nd4j.linalg.api.ndarray.INDArray;

public class PlotFiltersIterationListener
implements IterationListener {
    private List<String> variables;
    private int iteration = 1;
    private PlotFilters filters;
    private File outputFile = new File("render.png");

    public PlotFiltersIterationListener(PlotFilters plotFilters, List<String> variables, int iteration) {
        this.filters = plotFilters;
        this.variables = variables;
        this.iteration = iteration;
    }

    public List<String> getVariables() {
        return this.variables;
    }

    public void setVariables(List<String> variables) {
        this.variables = variables;
    }

    public int getIteration() {
        return this.iteration;
    }

    public void setIteration(int iteration) {
        this.iteration = iteration;
    }

    public PlotFilters getFilters() {
        return this.filters;
    }

    public void setFilters(PlotFilters filters) {
        this.filters = filters;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    @Override
    public boolean invoked() {
        return false;
    }

    @Override
    public void invoke() {
    }

    @Override
    public void iterationDone(Model model, int iteration) {
        if (iteration % this.iteration == 0) {
            INDArray weights = model.getParam(this.variables.get(0));
            this.filters.setInput(weights.transpose());
            this.filters.plot();
            INDArray plot = this.filters.getPlot();
            BufferedImage image = ImageLoader.toImage(plot);
            try {
                this.outputFile.createNewFile();
                ImageIO.write((RenderedImage)image, "png", this.outputFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

