/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.beans.ConstructorProperties;
import org.deeplearning4j.nn.conf.layers.BasePretrainNetwork;

public class AutoEncoder
extends BasePretrainNetwork {
    protected double corruptionLevel;
    protected double sparsity;

    private AutoEncoder(Builder builder) {
        super(builder);
        this.corruptionLevel = builder.corruptionLevel;
        this.sparsity = builder.sparsity;
    }

    public double getCorruptionLevel() {
        return this.corruptionLevel;
    }

    public double getSparsity() {
        return this.sparsity;
    }

    public void setCorruptionLevel(double corruptionLevel) {
        this.corruptionLevel = corruptionLevel;
    }

    public void setSparsity(double sparsity) {
        this.sparsity = sparsity;
    }

    public AutoEncoder() {
    }

    @Override
    public String toString() {
        return "AutoEncoder(super=" + super.toString() + ", corruptionLevel=" + this.getCorruptionLevel() + ", sparsity=" + this.getSparsity() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoEncoder)) {
            return false;
        }
        AutoEncoder other = (AutoEncoder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (Double.compare(this.getCorruptionLevel(), other.getCorruptionLevel()) != 0) {
            return false;
        }
        return Double.compare(this.getSparsity(), other.getSparsity()) == 0;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AutoEncoder;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        long $corruptionLevel = Double.doubleToLongBits(this.getCorruptionLevel());
        result = result * 59 + (int)($corruptionLevel >>> 32 ^ $corruptionLevel);
        long $sparsity = Double.doubleToLongBits(this.getSparsity());
        result = result * 59 + (int)($sparsity >>> 32 ^ $sparsity);
        return result;
    }

    public static class Builder
    extends BasePretrainNetwork.Builder<Builder> {
        private double corruptionLevel = 0.3f;
        private double sparsity = 0.0;

        public Builder() {
        }

        public Builder(double corruptionLevel) {
            this.corruptionLevel = corruptionLevel;
        }

        public Builder corruptionLevel(double corruptionLevel) {
            this.corruptionLevel = corruptionLevel;
            return this;
        }

        public Builder sparsity(double sparsity) {
            this.sparsity = sparsity;
            return this;
        }

        @Override
        public AutoEncoder build() {
            return new AutoEncoder(this);
        }

        @ConstructorProperties(value={"corruptionLevel", "sparsity"})
        public Builder(double corruptionLevel, double sparsity) {
            this.corruptionLevel = corruptionLevel;
            this.sparsity = sparsity;
        }
    }
}

