/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.override.ConfOverride;
import org.nd4j.linalg.factory.Nd4j;

public class MultiLayerConfiguration
implements Serializable,
Cloneable {
    protected List<NeuralNetConfiguration> confs;
    protected boolean pretrain = true;
    @Deprecated
    protected double dampingFactor = 100.0;
    protected Map<Integer, InputPreProcessor> inputPreProcessors = new HashMap<Integer, InputPreProcessor>();
    protected boolean backprop = false;

    public String toYaml() {
        ObjectMapper mapper = NeuralNetConfiguration.mapperYaml();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static MultiLayerConfiguration fromYaml(String json) {
        ObjectMapper mapper = NeuralNetConfiguration.mapperYaml();
        try {
            return (MultiLayerConfiguration)mapper.readValue(json, MultiLayerConfiguration.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toJson() {
        ObjectMapper mapper = NeuralNetConfiguration.mapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static MultiLayerConfiguration fromJson(String json) {
        ObjectMapper mapper = NeuralNetConfiguration.mapper();
        try {
            return (MultiLayerConfiguration)mapper.readValue(json, MultiLayerConfiguration.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.toJson();
    }

    public NeuralNetConfiguration getConf(int i) {
        return this.confs.get(i);
    }

    public MultiLayerConfiguration clone() {
        try {
            MultiLayerConfiguration clone = (MultiLayerConfiguration)super.clone();
            if (clone.confs != null) {
                ArrayList<NeuralNetConfiguration> list = new ArrayList<NeuralNetConfiguration>();
                for (NeuralNetConfiguration neuralNetConfiguration : clone.confs) {
                    list.add(neuralNetConfiguration.clone());
                }
                clone.confs = list;
            }
            if (clone.inputPreProcessors != null) {
                HashMap<Integer, InputPreProcessor> map = new HashMap<Integer, InputPreProcessor>();
                for (Map.Entry entry : clone.inputPreProcessors.entrySet()) {
                    map.put((Integer)entry.getKey(), ((InputPreProcessor)entry.getValue()).clone());
                }
                clone.inputPreProcessors = map;
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public InputPreProcessor getInputPreProcess(int curr) {
        return this.inputPreProcessors.get(curr);
    }

    public List<NeuralNetConfiguration> getConfs() {
        return this.confs;
    }

    public boolean isPretrain() {
        return this.pretrain;
    }

    @Deprecated
    public double getDampingFactor() {
        return this.dampingFactor;
    }

    public Map<Integer, InputPreProcessor> getInputPreProcessors() {
        return this.inputPreProcessors;
    }

    public boolean isBackprop() {
        return this.backprop;
    }

    public void setConfs(List<NeuralNetConfiguration> confs) {
        this.confs = confs;
    }

    public void setPretrain(boolean pretrain) {
        this.pretrain = pretrain;
    }

    @Deprecated
    public void setDampingFactor(double dampingFactor) {
        this.dampingFactor = dampingFactor;
    }

    public void setInputPreProcessors(Map<Integer, InputPreProcessor> inputPreProcessors) {
        this.inputPreProcessors = inputPreProcessors;
    }

    public void setBackprop(boolean backprop) {
        this.backprop = backprop;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiLayerConfiguration)) {
            return false;
        }
        MultiLayerConfiguration other = (MultiLayerConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<NeuralNetConfiguration> this$confs = this.getConfs();
        List<NeuralNetConfiguration> other$confs = other.getConfs();
        if (this$confs == null ? other$confs != null : !((Object)this$confs).equals(other$confs)) {
            return false;
        }
        if (this.isPretrain() != other.isPretrain()) {
            return false;
        }
        if (Double.compare(this.getDampingFactor(), other.getDampingFactor()) != 0) {
            return false;
        }
        Map<Integer, InputPreProcessor> this$inputPreProcessors = this.getInputPreProcessors();
        Map<Integer, InputPreProcessor> other$inputPreProcessors = other.getInputPreProcessors();
        if (this$inputPreProcessors == null ? other$inputPreProcessors != null : !((Object)this$inputPreProcessors).equals(other$inputPreProcessors)) {
            return false;
        }
        return this.isBackprop() == other.isBackprop();
    }

    protected boolean canEqual(Object other) {
        return other instanceof MultiLayerConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<NeuralNetConfiguration> $confs = this.getConfs();
        result = result * 59 + ($confs == null ? 0 : ((Object)$confs).hashCode());
        result = result * 59 + (this.isPretrain() ? 79 : 97);
        long $dampingFactor = Double.doubleToLongBits(this.getDampingFactor());
        result = result * 59 + (int)($dampingFactor >>> 32 ^ $dampingFactor);
        Map<Integer, InputPreProcessor> $inputPreProcessors = this.getInputPreProcessors();
        result = result * 59 + ($inputPreProcessors == null ? 0 : ((Object)$inputPreProcessors).hashCode());
        result = result * 59 + (this.isBackprop() ? 79 : 97);
        return result;
    }

    private MultiLayerConfiguration(List<NeuralNetConfiguration> confs, boolean pretrain, double dampingFactor, Map<Integer, InputPreProcessor> inputPreProcessors, boolean backprop) {
        this.confs = confs;
        this.pretrain = pretrain;
        this.dampingFactor = dampingFactor;
        this.inputPreProcessors = inputPreProcessors;
        this.backprop = backprop;
    }

    public MultiLayerConfiguration() {
    }

    public static class Builder {
        protected List<NeuralNetConfiguration> confs = new ArrayList<NeuralNetConfiguration>();
        protected boolean pretrain = true;
        protected double dampingFactor = 100.0;
        protected Map<Integer, InputPreProcessor> inputPreProcessors = new HashMap<Integer, InputPreProcessor>();
        protected boolean backprop = false;
        @Deprecated
        protected Map<Integer, ConfOverride> confOverrides = new HashMap<Integer, ConfOverride>();

        public Builder inputPreProcessor(Integer layer, InputPreProcessor processor) {
            this.inputPreProcessors.put(layer, processor);
            return this;
        }

        public Builder inputPreProcessors(Map<Integer, InputPreProcessor> processors) {
            this.inputPreProcessors = processors;
            return this;
        }

        public Builder backprop(boolean backprop) {
            this.backprop = backprop;
            return this;
        }

        @Deprecated
        public Builder dampingFactor(double dampingFactor) {
            this.dampingFactor = dampingFactor;
            return this;
        }

        public Builder pretrain(boolean pretrain) {
            this.pretrain = pretrain;
            return this;
        }

        public Builder confs(List<NeuralNetConfiguration> confs) {
            this.confs = confs;
            return this;
        }

        public MultiLayerConfiguration build() {
            MultiLayerConfiguration conf = new MultiLayerConfiguration();
            conf.confs = this.confs;
            conf.pretrain = this.pretrain;
            conf.dampingFactor = this.dampingFactor;
            conf.backprop = this.backprop;
            conf.inputPreProcessors = this.inputPreProcessors;
            Nd4j.getRandom().setSeed(conf.getConf(0).getSeed());
            return conf;
        }

        public String toString() {
            return "Builder{confs=" + this.confs + ", pretrain=" + this.pretrain + ", dampingFactor=" + this.dampingFactor + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder builder = (Builder)o;
            return Double.compare(builder.dampingFactor, this.dampingFactor) == 0 && this.pretrain == builder.pretrain && !(this.confs == null ? builder.confs != null : !this.confs.equals(builder.confs));
        }

        public int hashCode() {
            int result = this.confs != null ? this.confs.hashCode() : 0;
            result = 31 * result + (this.pretrain ? 1 : 0);
            long temp = Double.doubleToLongBits(this.dampingFactor);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        @Deprecated
        public Builder override(ConfOverride override) {
            this.confOverrides.put(this.confOverrides.size(), override);
            return this;
        }

        @Deprecated
        public Builder override(int layer, ConfOverride override) {
            this.confOverrides.put(layer, override);
            return this;
        }
    }
}

