/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.clustering;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.nd4j.linalg.api.ndarray.INDArray;

public class Cluster {
    private String id = UUID.randomUUID().toString();
    private INDArray center;
    private List<INDArray> points = new ArrayList<INDArray>();

    public Cluster() {
    }

    public Cluster(String id) {
        this.id = id;
    }

    public Cluster(INDArray center) {
        this.center = center;
    }

    public Cluster(String id, INDArray center) {
        this.id = id;
        this.center = center;
    }

    public Cluster(INDArray center, List<INDArray> points) {
        this.center = center;
        this.points = points;
    }

    public void addPoint(INDArray point) {
        this.addPoint(point, true);
    }

    public void addPoint(INDArray point, boolean moveClusterCenter) {
        if (moveClusterCenter) {
            this.center.muli((Number)this.points.size()).addi(point).divi((Number)(this.points.size() + 1));
        }
        this.getPoints().add(point);
    }

    public void removePoints() {
        if (this.getPoints() != null) {
            this.getPoints().clear();
        }
    }

    public INDArray getCenter() {
        return this.center;
    }

    public void setCenter(INDArray center) {
        this.center = center;
    }

    public List<INDArray> getPoints() {
        return this.points;
    }

    public void setPoints(List<INDArray> points) {
        this.points = points;
    }
}

