/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.params;

import java.util.Map;
import org.canova.api.conf.Configuration;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.distribution.Distributions;
import org.deeplearning4j.nn.conf.layers.GravesLSTM;
import org.deeplearning4j.nn.weights.WeightInitUtil;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.rng.distribution.Distribution;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;

public class GravesLSTMParamInitializer
implements ParamInitializer {
    public static final String RECURRENT_WEIGHT_KEY = "RW";
    public static final String BIAS_KEY = "b";
    public static final String INPUT_WEIGHT_KEY = "W";

    @Override
    public void init(Map<String, INDArray> params, NeuralNetConfiguration conf) {
        GravesLSTM layerConf = (GravesLSTM)conf.getLayer();
        Distribution dist = Distributions.createDistribution(layerConf.getDist());
        int nL = layerConf.getNOut();
        int nLast = layerConf.getNIn();
        conf.addVariable(RECURRENT_WEIGHT_KEY);
        conf.addVariable(INPUT_WEIGHT_KEY);
        conf.addVariable(BIAS_KEY);
        params.put(RECURRENT_WEIGHT_KEY, WeightInitUtil.initWeights(nL, 4 * nL + 3, layerConf.getWeightInit(), dist));
        params.put(INPUT_WEIGHT_KEY, WeightInitUtil.initWeights(nLast, 4 * nL, layerConf.getWeightInit(), dist));
        INDArray biases = Nd4j.zeros((int)1, (int)(4 * nL));
        biases.put(new INDArrayIndex[]{new NDArrayIndex(new int[]{0}), NDArrayIndex.interval((int)nL, (int)(2 * nL))}, Nd4j.ones((int)1, (int)nL).muli((Number)5));
        params.put(BIAS_KEY, biases);
        params.get(RECURRENT_WEIGHT_KEY).data().persist();
        params.get(INPUT_WEIGHT_KEY).data().persist();
        params.get(BIAS_KEY).data().persist();
    }

    @Override
    public void init(Map<String, INDArray> params, NeuralNetConfiguration conf, Configuration extraConf) {
        this.init(params, conf);
    }
}

