/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.deeplearning4j.berkeley.Pair;
import org.jblas.DoubleMatrix;

public class InputSplit {
    public static void splitInputs(DoubleMatrix inputs, DoubleMatrix outcomes, List<Pair<DoubleMatrix, DoubleMatrix>> train, List<Pair<DoubleMatrix, DoubleMatrix>> test, double split) {
        List inputRows = inputs.rowsAsList();
        List outcomeRows = outcomes.rowsAsList();
        assert (inputRows.size() == outcomeRows.size());
        ArrayList<Pair<DoubleMatrix, DoubleMatrix>> list = new ArrayList<Pair<DoubleMatrix, DoubleMatrix>>();
        for (int i = 0; i < inputRows.size(); ++i) {
            list.add(new Pair(inputRows.get(i), outcomeRows.get(i)));
        }
        InputSplit.splitInputs(list, train, test, split);
    }

    public static void splitInputs(List<Pair<DoubleMatrix, DoubleMatrix>> pairs, List<Pair<DoubleMatrix, DoubleMatrix>> train, List<Pair<DoubleMatrix, DoubleMatrix>> test, double split) {
        Random rand = new Random();
        for (Pair<DoubleMatrix, DoubleMatrix> pair : pairs) {
            if (rand.nextDouble() <= split) {
                train.add(pair);
                continue;
            }
            test.add(pair);
        }
    }
}

