/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.gradient;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.deeplearning4j.nn.Persistable;
import org.deeplearning4j.nn.gradient.LogisticRegressionGradient;
import org.deeplearning4j.nn.gradient.NeuralNetworkGradient;
import org.deeplearning4j.util.SerializationUtils;

public class MultiLayerGradient
implements Persistable {
    private static final long serialVersionUID = 5262146791172613616L;
    private List<NeuralNetworkGradient> gradients;
    private LogisticRegressionGradient logRegGradient;

    public MultiLayerGradient(List<NeuralNetworkGradient> gradients, LogisticRegressionGradient logRegGradient) {
        this.gradients = gradients;
        this.logRegGradient = logRegGradient;
    }

    @Override
    public void write(OutputStream os) {
        SerializationUtils.writeObject(this, os);
    }

    @Override
    public void load(InputStream is) {
        MultiLayerGradient read = (MultiLayerGradient)SerializationUtils.readObject(is);
        this.gradients = read.gradients;
        this.logRegGradient = read.logRegGradient;
    }

    public void div(int num) {
        for (NeuralNetworkGradient g : this.gradients) {
            g.div(num);
        }
    }

    public synchronized List<NeuralNetworkGradient> getGradients() {
        return this.gradients;
    }

    public synchronized void setGradients(List<NeuralNetworkGradient> gradients) {
        this.gradients = gradients;
    }

    public synchronized LogisticRegressionGradient getLogRegGradient() {
        return this.logRegGradient;
    }

    public synchronized void setLogRegGradient(LogisticRegressionGradient logRegGradient) {
        this.logRegGradient = logRegGradient;
    }
}

