/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.optimize.listeners;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.optimize.api.IterationListener;

public class ComposableIterationListener
implements IterationListener {
    private Collection<IterationListener> listeners = new ArrayList<IterationListener>();

    public ComposableIterationListener(IterationListener ... iterationListener) {
        this.listeners.addAll(Arrays.asList(iterationListener));
    }

    public ComposableIterationListener(Collection<IterationListener> listeners) {
        this.listeners = listeners;
    }

    @Override
    public void iterationDone(Model model, int iteration) {
        for (IterationListener listener : this.listeners) {
            listener.iterationDone(model, iteration);
        }
    }
}

