/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.params;

import java.util.Map;
import org.canova.api.conf.Configuration;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.distribution.Distributions;
import org.deeplearning4j.nn.weights.WeightInitUtil;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.rng.distribution.Distribution;
import org.nd4j.linalg.factory.Nd4j;

public class DefaultParamInitializer
implements ParamInitializer {
    public static final String WEIGHT_KEY = "W";
    public static final String BIAS_KEY = "b";

    @Override
    public void init(Map<String, INDArray> params, NeuralNetConfiguration conf) {
        params.put(WEIGHT_KEY, this.createWeightMatrix(conf));
        params.put(BIAS_KEY, this.createBias(conf));
        conf.addVariable(WEIGHT_KEY);
        conf.addVariable(BIAS_KEY);
    }

    @Override
    public void init(Map<String, INDArray> params, NeuralNetConfiguration conf, Configuration extraConf) {
        this.init(params, conf);
    }

    protected INDArray createBias(NeuralNetConfiguration conf) {
        INDArray ret = Nd4j.zeros((int)conf.getnOut());
        ret.data().persist();
        return ret;
    }

    protected INDArray createWeightMatrix(NeuralNetConfiguration conf) {
        Distribution dist = Distributions.createDistribution(conf.getDist());
        INDArray ret = WeightInitUtil.initWeights(conf.getnIn(), conf.getnOut(), conf.getWeightInit(), dist);
        ret.data().persist();
        return ret;
    }
}

