/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.params;

import java.util.Map;
import org.canova.api.conf.Configuration;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.distribution.Distributions;
import org.deeplearning4j.nn.weights.WeightInitUtil;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.rng.distribution.Distribution;
import org.nd4j.linalg.factory.Nd4j;

public class ConvolutionParamInitializer
implements ParamInitializer {
    public static final String CONVOLUTION_BIAS = "convbias";
    public static final String CONVOLUTION_WEIGHTS = "convweights";

    @Override
    public void init(Map<String, INDArray> params, NeuralNetConfiguration conf) {
        if (conf.getFilterSize().length < 4) {
            throw new IllegalArgumentException("Filter size must be == 4");
        }
        params.put(CONVOLUTION_BIAS, this.createBias(conf));
        params.put(CONVOLUTION_WEIGHTS, this.createWeightMatrix(conf));
        conf.addVariable(CONVOLUTION_WEIGHTS);
        conf.addVariable(CONVOLUTION_BIAS);
    }

    @Override
    public void init(Map<String, INDArray> params, NeuralNetConfiguration conf, Configuration extraConf) {
        this.init(params, conf);
    }

    protected INDArray createBias(NeuralNetConfiguration conf) {
        return Nd4j.zeros((int)conf.getFilterSize()[0]);
    }

    protected INDArray createWeightMatrix(NeuralNetConfiguration conf) {
        Distribution dist = Distributions.createDistribution(conf.getDist());
        return WeightInitUtil.initWeights(conf.getFilterSize(), conf.getWeightInit(), dist);
    }
}

