/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.iterator.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.deeplearning4j.datasets.iterator.DataSetIterator;
import org.deeplearning4j.datasets.iterator.DataSetPreProcessor;
import org.nd4j.linalg.dataset.api.DataSet;

public class ListDataSetIterator
implements DataSetIterator {
    private static final long serialVersionUID = -7569201667767185411L;
    private int curr = 0;
    private int batch = 10;
    private List<org.nd4j.linalg.dataset.DataSet> list;
    private DataSetPreProcessor preProcessor;

    public ListDataSetIterator(Collection<org.nd4j.linalg.dataset.DataSet> coll, int batch) {
        this.list = new ArrayList<org.nd4j.linalg.dataset.DataSet>(coll);
        this.batch = batch;
    }

    public ListDataSetIterator(Collection<org.nd4j.linalg.dataset.DataSet> coll) {
        this(coll, 5);
    }

    @Override
    public synchronized boolean hasNext() {
        return this.curr < this.list.size();
    }

    @Override
    public synchronized org.nd4j.linalg.dataset.DataSet next() {
        return this.next(this.batch);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public int totalExamples() {
        return this.list.size();
    }

    public int inputColumns() {
        return this.list.get(0).getFeatureMatrix().columns();
    }

    public int totalOutcomes() {
        return this.list.get(0).getLabels().columns();
    }

    public synchronized void reset() {
        this.curr = 0;
    }

    public int batch() {
        return this.batch;
    }

    public synchronized int cursor() {
        return this.curr;
    }

    public int numExamples() {
        return this.list.size();
    }

    public void setPreProcessor(org.nd4j.linalg.dataset.api.DataSetPreProcessor preProcessor) {
        this.preProcessor = (DataSetPreProcessor)preProcessor;
    }

    public org.nd4j.linalg.dataset.DataSet next(int num) {
        int end = this.curr + num;
        ArrayList<org.nd4j.linalg.dataset.DataSet> r = new ArrayList<org.nd4j.linalg.dataset.DataSet>();
        if (end >= this.list.size()) {
            end = this.list.size();
        }
        while (this.curr < end) {
            r.add(this.list.get(this.curr));
            ++this.curr;
        }
        org.nd4j.linalg.dataset.DataSet d = org.nd4j.linalg.dataset.DataSet.merge(r);
        if (this.preProcessor != null) {
            this.preProcessor.preProcess((DataSet)d);
        }
        return d;
    }
}

