/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.params;

import java.util.Map;
import org.canova.api.conf.Configuration;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.distribution.Distributions;
import org.deeplearning4j.nn.weights.WeightInitUtil;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.rng.distribution.Distribution;
import org.nd4j.linalg.factory.Nd4j;

public class LSTMParamInitializer
implements ParamInitializer {
    public static final String RECURRENT_WEIGHTS = "recurrentweights";
    public static final String DECODER_BIAS = "decoderbias";
    public static final String DECODER_WEIGHTS = "decoderweights";

    @Override
    public void init(Map<String, INDArray> params, NeuralNetConfiguration conf) {
        Distribution dist = Distributions.createDistribution(conf.getDist());
        int inputSize = conf.getnIn();
        int hiddenSize = conf.getnIn();
        int outputSize = conf.getnOut();
        conf.addVariable(RECURRENT_WEIGHTS);
        conf.addVariable(DECODER_WEIGHTS);
        conf.addVariable(DECODER_BIAS);
        params.put(RECURRENT_WEIGHTS, WeightInitUtil.initWeights(inputSize + hiddenSize + 1, 4 * hiddenSize, conf.getWeightInit(), dist));
        params.put(DECODER_WEIGHTS, WeightInitUtil.initWeights(hiddenSize, outputSize, conf.getWeightInit(), dist));
        params.put(DECODER_BIAS, Nd4j.zeros((int)outputSize));
        params.get(RECURRENT_WEIGHTS).data().persist();
        params.get(DECODER_BIAS).data().persist();
        params.get(DECODER_WEIGHTS).data().persist();
    }

    @Override
    public void init(Map<String, INDArray> params, NeuralNetConfiguration conf, Configuration extraConf) {
        this.init(params, conf);
    }
}

