/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.optimize.Solver;
import org.deeplearning4j.optimize.api.ConvexOptimizer;
import org.deeplearning4j.optimize.api.IterationListener;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.NDArrayIndex;

public abstract class BaseLayer
implements Layer {
    protected INDArray input;
    protected Map<String, INDArray> params;
    protected NeuralNetConfiguration conf;
    protected INDArray dropoutMask;
    protected ParamInitializer paramInitializer;
    protected double score = 0.0;
    protected ConvexOptimizer optimizer;
    protected Collection<IterationListener> iterationListeners = new ArrayList<IterationListener>();

    public BaseLayer(NeuralNetConfiguration conf) {
        this.conf = conf;
    }

    public BaseLayer(NeuralNetConfiguration conf, INDArray input) {
        this.input = input;
        this.conf = conf;
    }

    @Override
    public Collection<IterationListener> getIterationListeners() {
        return this.iterationListeners;
    }

    @Override
    public void setIterationListeners(Collection<IterationListener> listeners) {
        this.iterationListeners = listeners != null ? listeners : new ArrayList();
    }

    @Override
    public Gradient error(INDArray errorSignal) {
        INDArray W = this.getParam("W");
        DefaultGradient nextLayerGradient = new DefaultGradient();
        INDArray wErrorSignal = errorSignal.mmul(W);
        nextLayerGradient.gradientForVariable().put("W", wErrorSignal);
        return nextLayerGradient;
    }

    @Override
    public INDArray derivativeActivation(INDArray input) {
        INDArray deriv = Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createTransform(this.conf().getActivationFunction(), this.activate(input)).derivative());
        return deriv;
    }

    @Override
    public Gradient errorSignal(Gradient error, INDArray input) {
        INDArray derivative = this.derivativeActivation(input);
        DefaultGradient ret = new DefaultGradient();
        ret.gradientForVariable().put("W", derivative.mul(error.getGradientFor("W")));
        return ret;
    }

    @Override
    public Gradient calcGradient(Gradient layerError, INDArray activation) {
        DefaultGradient ret = new DefaultGradient();
        INDArray weightErrorSignal = layerError.getGradientFor("W");
        INDArray weightError = weightErrorSignal.transpose().mmul(activation).divi((Number)weightErrorSignal.rows()).transpose();
        ret.gradientForVariable().put("W", weightError);
        INDArray biasGradient = weightError.sum(0).divi((Number)weightErrorSignal.rows());
        ret.gradientForVariable().put("b", biasGradient);
        return ret;
    }

    @Override
    public Gradient backwardGradient(INDArray activation, Gradient errorSignal) {
        Gradient propError = this.error(activation);
        INDArray deriv = this.derivativeActivation(activation);
        DefaultGradient ret = new DefaultGradient();
        ret.gradientForVariable().put("W", propError.getGradientFor("W").mul(deriv));
        return ret;
    }

    @Override
    public void fit() {
        this.fit(this.input);
    }

    @Override
    public void setScore() {
    }

    @Override
    public void iterate(INDArray input) {
        this.input = input;
        Gradient gradient = this.gradient();
        this.update(gradient);
    }

    @Override
    public void update(Gradient gradient) {
        for (String s : this.conf.variables()) {
            if (!gradient.gradientForVariable().containsKey(s)) continue;
            this.getParam(s).addi(gradient.gradientForVariable().get(s));
        }
    }

    @Override
    public ConvexOptimizer getOptimizer() {
        if (this.optimizer == null) {
            Solver solver = new Solver.Builder().model(this).configure(this.conf()).build();
            this.optimizer = solver.getOptimizer();
        }
        return this.optimizer;
    }

    @Override
    public void setConf(NeuralNetConfiguration conf) {
        this.conf = conf;
    }

    @Override
    public void setParam(String key, INDArray val) {
        this.params.put(key, val);
    }

    @Override
    public INDArray params() {
        ArrayList<INDArray> ret = new ArrayList<INDArray>();
        for (String s : this.params.keySet()) {
            ret.add(this.params.get(s));
        }
        return Nd4j.toFlattened(ret);
    }

    @Override
    public void setParams(INDArray params) {
        List<String> gradientList = this.conf.variables();
        int length = 0;
        for (String s : gradientList) {
            length += this.getParam(s).length();
        }
        if (params.length() != length) {
            throw new IllegalArgumentException("Unable to set parameters: must be of length " + length);
        }
        int idx = 0;
        for (int i = 0; i < gradientList.size(); ++i) {
            INDArray param = this.getParam(gradientList.get(i));
            INDArray get = params.get(new NDArrayIndex[]{NDArrayIndex.interval((int)idx, (int)(idx + param.length()))});
            if (param.length() != get.length()) {
                throw new IllegalStateException("Parameter " + gradientList.get(i) + " should have been of length " + param.length() + " but was " + get.length());
            }
            param.assign(get.reshape(param.shape()));
            idx += param.length();
        }
        this.setScore();
    }

    @Override
    public void initParams() {
        this.paramInitializer.init(this.paramTable(), this.conf());
    }

    @Override
    public Map<String, INDArray> paramTable() {
        return this.params;
    }

    @Override
    public void setParamTable(Map<String, INDArray> paramTable) {
        this.params = paramTable;
    }

    @Override
    public INDArray getParam(String param) {
        return this.params.get(param);
    }

    @Override
    public INDArray preOutput(INDArray x) {
        if (x == null) {
            throw new IllegalArgumentException("No null input allowed");
        }
        this.input = x;
        INDArray b = this.getParam("b");
        INDArray W = this.getParam("W");
        INDArray ret = this.input().mmul(W).addiRowVector(b);
        return ret;
    }

    @Override
    public int batchSize() {
        return this.input.rows();
    }

    @Override
    public INDArray activate() {
        INDArray b = this.getParam("b");
        INDArray W = this.getParam("W");
        if (this.conf.getActivationFunction().equals("softmax")) {
            return Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createTransform(this.conf.getActivationFunction(), this.input().mmul(W).addiRowVector(b)));
        }
        return Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createTransform(this.conf.getActivationFunction(), this.input().mmul(W).addiRowVector(b)));
    }

    @Override
    public INDArray activate(INDArray input) {
        this.input = input;
        return this.activate();
    }

    @Override
    public INDArray activationMean() {
        INDArray b = this.getParam("b");
        INDArray W = this.getParam("W");
        return this.input().mmul(W).addiRowVector(b);
    }

    @Override
    public NeuralNetConfiguration conf() {
        return this.conf;
    }

    @Override
    public void clear() {
        if (this.input != null) {
            this.input.data().destroy();
            this.input = null;
        }
    }

    protected void applyDropOutIfNecessary(INDArray input) {
        if (this.conf.getDropOut() > 0.0) {
            this.dropoutMask = Nd4j.rand((int)input.rows(), (int)input.columns()).gt((Number)this.conf.getDropOut());
        } else if (this.dropoutMask != null) {
            this.dropoutMask = Nd4j.ones((int)input.rows(), (int)this.conf.getnOut());
        }
        if (this.conf.getDropOut() > 0.0) {
            input.linearView().muli(this.dropoutMask);
        }
    }

    @Override
    public void merge(Layer l, int batchSize) {
        this.setParams(this.params().addi(l.params().divi((Number)batchSize)));
    }

    @Override
    public Layer clone() {
        INDArray W = this.getParam("W");
        INDArray b = this.getParam("b");
        Layer layer = null;
        try {
            Constructor<?> c = this.getClass().getConstructor(NeuralNetConfiguration.class, INDArray.class, INDArray.class, INDArray.class);
            layer = (Layer)c.newInstance(this.conf, W.dup(), b.dup(), this.input != null ? this.input.dup() : null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return layer;
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.FEED_FORWARD;
    }

    @Override
    public int numParams() {
        int ret = 0;
        for (INDArray val : this.params.values()) {
            ret += val.length();
        }
        return ret;
    }

    @Override
    public void fit(INDArray input) {
        if (input != null) {
            this.input = input;
        }
        Solver solver = new Solver.Builder().model(this).configure(this.conf()).listeners(this.getIterationListeners()).build();
        this.optimizer = solver.getOptimizer();
        solver.optimize();
    }

    @Override
    public Pair<Gradient, Double> gradientAndScore() {
        return new Pair<Gradient, Double>(this.gradient(), this.score());
    }

    @Override
    public double score() {
        return this.score;
    }

    @Override
    public INDArray input() {
        return this.input;
    }

    @Override
    public void validateInput() {
    }

    protected Gradient createGradient(INDArray ... gradients) {
        DefaultGradient ret = new DefaultGradient();
        if (gradients.length != this.conf.variables().size()) {
            throw new IllegalArgumentException("Unable to create gradients...not equal to number of parameters");
        }
        for (int i = 0; i < gradients.length; ++i) {
            INDArray paramI = this.getParam(this.conf.variables().get(i));
            if (!Arrays.equals(paramI.shape(), gradients[i].shape())) {
                throw new IllegalArgumentException("Gradient at index " + i + " had wrong gradient size of " + Arrays.toString(gradients[i].shape()) + " when should have been " + Arrays.toString(paramI.shape()));
            }
            ret.gradientForVariable().put(this.conf.variables().get(i), gradients[i]);
        }
        return ret;
    }

    @Override
    public Layer transpose() {
        INDArray W = this.getParam("W");
        INDArray b = this.getParam("b");
        Layer layer = null;
        try {
            Constructor<?> c = this.getClass().getConstructor(NeuralNetConfiguration.class, INDArray.class, INDArray.class, INDArray.class);
            NeuralNetConfiguration clone = this.conf.clone();
            int nIn = clone.getnOut();
            int nOut = clone.getnIn();
            clone.setnIn(nIn);
            clone.setnOut(nOut);
            layer = (Layer)c.newInstance(this.conf, W.transpose().dup(), b.transpose().dup(), this.input != null ? this.input.transpose().dup() : null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return layer;
    }

    @Override
    public Pair<Gradient, Gradient> backWard(Gradient ixes, Gradient deltas, INDArray activation, String previousActivation) {
        INDArray delta = activation.transpose().mmul(ixes.getGradientFor("W"));
        INDArray biasDelta = delta.mean(0);
        INDArray weightsPlusBias = this.getParam("W").transpose();
        DefaultGradient ret = new DefaultGradient();
        INDArray errorForEach = ixes.getGradientFor("W");
        INDArray nextIx = errorForEach.mmul(weightsPlusBias).muli(Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createTransform(previousActivation, activation).derivative()));
        ret.gradientForVariable().put("W", nextIx);
        INDArray deltaColumnSums = nextIx.isVector() ? nextIx.dup() : nextIx.mean(0);
        ret.gradientForVariable().put("b", deltaColumnSums);
        DefaultGradient weightDelta = new DefaultGradient();
        weightDelta.gradientForVariable().put("W", delta);
        weightDelta.gradientForVariable().put("b", biasDelta);
        return new Pair<Gradient, Gradient>(ret, weightDelta);
    }

    @Override
    public void accumulateScore(double accum) {
        this.score += accum;
    }
}

