/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.OutputPreProcessor;
import org.deeplearning4j.nn.conf.override.ConfOverride;

public class MultiLayerConfiguration
implements Serializable {
    protected int[] hiddenLayerSizes;
    protected List<NeuralNetConfiguration> confs;
    protected boolean useDropConnect = false;
    protected boolean useGaussNewtonVectorProductBackProp = false;
    protected boolean pretrain = true;
    protected boolean useRBMPropUpAsActivations = true;
    protected double dampingFactor = 100.0;
    protected Map<Integer, OutputPreProcessor> processors = new HashMap<Integer, OutputPreProcessor>();
    protected Map<Integer, InputPreProcessor> inputPreProcessors = new HashMap<Integer, InputPreProcessor>();
    protected boolean backward = false;

    public MultiLayerConfiguration() {
    }

    public MultiLayerConfiguration(MultiLayerConfiguration multiLayerConfiguration) {
        this.hiddenLayerSizes = multiLayerConfiguration.hiddenLayerSizes;
        this.confs = new ArrayList<NeuralNetConfiguration>(multiLayerConfiguration.confs);
        this.useDropConnect = multiLayerConfiguration.useDropConnect;
        this.useGaussNewtonVectorProductBackProp = multiLayerConfiguration.useGaussNewtonVectorProductBackProp;
        this.pretrain = multiLayerConfiguration.pretrain;
        this.useRBMPropUpAsActivations = multiLayerConfiguration.useRBMPropUpAsActivations;
        this.dampingFactor = multiLayerConfiguration.dampingFactor;
        this.processors = new HashMap<Integer, OutputPreProcessor>(multiLayerConfiguration.processors);
        this.backward = multiLayerConfiguration.backward;
        this.inputPreProcessors = multiLayerConfiguration.inputPreProcessors;
    }

    public NeuralNetConfiguration getConf(int i) {
        return this.confs.get(i);
    }

    public OutputPreProcessor getPreProcessor(int layer) {
        return this.processors.get(layer);
    }

    public InputPreProcessor getInputPreProcess(int layer) {
        return this.inputPreProcessors.get(layer);
    }

    public double getDampingFactor() {
        return this.dampingFactor;
    }

    public void setDampingFactor(double dampingFactor) {
        this.dampingFactor = dampingFactor;
    }

    public boolean isUseRBMPropUpAsActivations() {
        return this.useRBMPropUpAsActivations;
    }

    public void setUseRBMPropUpAsActivations(boolean useRBMPropUpAsActivations) {
        this.useRBMPropUpAsActivations = useRBMPropUpAsActivations;
    }

    public boolean isUseDropConnect() {
        return this.useDropConnect;
    }

    public void setUseDropConnect(boolean useDropConnect) {
        this.useDropConnect = useDropConnect;
    }

    public boolean isUseGaussNewtonVectorProductBackProp() {
        return this.useGaussNewtonVectorProductBackProp;
    }

    public void setUseGaussNewtonVectorProductBackProp(boolean useGaussNewtonVectorProductBackProp) {
        this.useGaussNewtonVectorProductBackProp = useGaussNewtonVectorProductBackProp;
    }

    public boolean isPretrain() {
        return this.pretrain;
    }

    public void setPretrain(boolean pretrain) {
        this.pretrain = pretrain;
    }

    public int[] getHiddenLayerSizes() {
        return this.hiddenLayerSizes;
    }

    public void setHiddenLayerSizes(int[] hiddenLayerSizes) {
        this.hiddenLayerSizes = hiddenLayerSizes;
    }

    public List<NeuralNetConfiguration> getConfs() {
        return this.confs;
    }

    public void setConfs(List<NeuralNetConfiguration> confs) {
        this.confs = confs;
    }

    public Map<Integer, OutputPreProcessor> getProcessors() {
        return this.processors;
    }

    public void setProcessors(Map<Integer, OutputPreProcessor> processors) {
        this.processors = processors;
    }

    public boolean isBackward() {
        return this.backward;
    }

    public void setBackward(boolean backward) {
        this.backward = backward;
    }

    public String toJson() {
        ObjectMapper mapper = NeuralNetConfiguration.mapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static MultiLayerConfiguration fromJson(String json) {
        ObjectMapper mapper = NeuralNetConfiguration.mapper();
        try {
            return (MultiLayerConfiguration)mapper.readValue(json, MultiLayerConfiguration.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "MultiLayerConfiguration{hiddenLayerSizes=" + Arrays.toString(this.hiddenLayerSizes) + ", confs=" + this.confs + ", useDropConnect=" + this.useDropConnect + ", useGaussNewtonVectorProductBackProp=" + this.useGaussNewtonVectorProductBackProp + ", pretrain=" + this.pretrain + ", useRBMPropUpAsActivations=" + this.useRBMPropUpAsActivations + ", dampingFactor=" + this.dampingFactor + ", processors=" + this.processors + ", backward=" + this.backward + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiLayerConfiguration)) {
            return false;
        }
        MultiLayerConfiguration that = (MultiLayerConfiguration)o;
        if (this.backward != that.backward) {
            return false;
        }
        if (Double.compare(that.dampingFactor, this.dampingFactor) != 0) {
            return false;
        }
        if (this.pretrain != that.pretrain) {
            return false;
        }
        if (this.useDropConnect != that.useDropConnect) {
            return false;
        }
        if (this.useGaussNewtonVectorProductBackProp != that.useGaussNewtonVectorProductBackProp) {
            return false;
        }
        if (this.useRBMPropUpAsActivations != that.useRBMPropUpAsActivations) {
            return false;
        }
        if (this.confs != null ? !this.confs.equals(that.confs) : that.confs != null) {
            return false;
        }
        return Arrays.equals(this.hiddenLayerSizes, that.hiddenLayerSizes);
    }

    public int hashCode() {
        int result = this.hiddenLayerSizes != null ? Arrays.hashCode(this.hiddenLayerSizes) : 0;
        result = 31 * result + (this.confs != null ? this.confs.hashCode() : 0);
        result = 31 * result + (this.useDropConnect ? 1 : 0);
        result = 31 * result + (this.useGaussNewtonVectorProductBackProp ? 1 : 0);
        result = 31 * result + (this.pretrain ? 1 : 0);
        result = 31 * result + (this.useRBMPropUpAsActivations ? 1 : 0);
        long temp = Double.doubleToLongBits(this.dampingFactor);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.processors != null ? this.processors.hashCode() : 0);
        result = 31 * result + (this.backward ? 1 : 0);
        return result;
    }

    public MultiLayerConfiguration clone() {
        return new MultiLayerConfiguration(this);
    }

    public static class Builder {
        protected List<NeuralNetConfiguration> confs = new ArrayList<NeuralNetConfiguration>();
        protected int[] hiddenLayerSizes;
        protected boolean useDropConnect = false;
        protected boolean pretrain = true;
        protected boolean useRBMPropUpAsActivations = false;
        protected double dampingFactor = 100.0;
        protected Map<Integer, OutputPreProcessor> preProcessors = new HashMap<Integer, OutputPreProcessor>();
        protected Map<Integer, InputPreProcessor> inputPreProcessor = new HashMap<Integer, InputPreProcessor>();
        protected boolean backward = false;
        protected Map<Integer, ConfOverride> confOverrides = new HashMap<Integer, ConfOverride>();

        public Builder inputPreProcessors(Map<Integer, InputPreProcessor> inputPreProcessor) {
            this.inputPreProcessor = inputPreProcessor;
            return this;
        }

        public Builder backward(boolean backward) {
            this.backward = backward;
            return this;
        }

        public Builder inputPreProcessor(Integer layer, InputPreProcessor preProcessor) {
            this.inputPreProcessor.put(layer, preProcessor);
            return this;
        }

        public Builder preProcessor(Integer layer, OutputPreProcessor preProcessor) {
            this.preProcessors.put(layer, preProcessor);
            return this;
        }

        public Builder preProcessors(Map<Integer, OutputPreProcessor> preProcessors) {
            this.preProcessors = preProcessors;
            return this;
        }

        public Builder dampingFactor(double dampingFactor) {
            this.dampingFactor = dampingFactor;
            return this;
        }

        public Builder useRBMPropUpAsActivations(boolean useRBMPropUpAsActivations) {
            this.useRBMPropUpAsActivations = useRBMPropUpAsActivations;
            return this;
        }

        public Builder pretrain(boolean pretrain) {
            this.pretrain = pretrain;
            return this;
        }

        public Builder useDropConnect(boolean useDropConnect) {
            this.useDropConnect = useDropConnect;
            return this;
        }

        public Builder confs(List<NeuralNetConfiguration> confs) {
            this.confs = confs;
            return this;
        }

        public Builder hiddenLayerSizes(int ... hiddenLayerSizes) {
            this.hiddenLayerSizes = hiddenLayerSizes;
            return this;
        }

        public MultiLayerConfiguration build() {
            MultiLayerConfiguration conf = new MultiLayerConfiguration();
            conf.confs = this.confs;
            if (this.hiddenLayerSizes == null) {
                throw new IllegalStateException("Please specify hidden layer sizes");
            }
            conf.hiddenLayerSizes = this.hiddenLayerSizes;
            conf.useDropConnect = this.useDropConnect;
            conf.pretrain = this.pretrain;
            conf.useRBMPropUpAsActivations = this.useRBMPropUpAsActivations;
            conf.dampingFactor = this.dampingFactor;
            conf.processors = this.preProcessors;
            conf.backward = this.backward;
            conf.inputPreProcessors = this.inputPreProcessor;
            return conf;
        }

        public String toString() {
            return "Builder{confs=" + this.confs + ", hiddenLayerSizes=" + Arrays.toString(this.hiddenLayerSizes) + ", useDropConnect=" + this.useDropConnect + ", pretrain=" + this.pretrain + ", useRBMPropUpAsActivations=" + this.useRBMPropUpAsActivations + ", dampingFactor=" + this.dampingFactor + ", preProcessors=" + this.preProcessors + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder builder = (Builder)o;
            return Double.compare(builder.dampingFactor, this.dampingFactor) == 0 && this.pretrain == builder.pretrain && this.useDropConnect == builder.useDropConnect && this.useRBMPropUpAsActivations == builder.useRBMPropUpAsActivations && !(this.confs == null ? builder.confs != null : !this.confs.equals(builder.confs)) && Arrays.equals(this.hiddenLayerSizes, builder.hiddenLayerSizes);
        }

        public int hashCode() {
            int result = this.confs != null ? this.confs.hashCode() : 0;
            result = 31 * result + (this.hiddenLayerSizes != null ? Arrays.hashCode(this.hiddenLayerSizes) : 0);
            result = 31 * result + (this.useDropConnect ? 1 : 0);
            result = 31 * result + (this.pretrain ? 1 : 0);
            result = 31 * result + (this.useRBMPropUpAsActivations ? 1 : 0);
            long temp = Double.doubleToLongBits(this.dampingFactor);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            result = 31 * result + (this.preProcessors != null ? this.preProcessors.hashCode() : 0);
            return result;
        }

        public Builder override(ConfOverride override) {
            this.confOverrides.put(this.confOverrides.size(), override);
            return this;
        }

        public Builder override(int layer, ConfOverride override) {
            this.confOverrides.put(layer, override);
            return this;
        }
    }
}

