/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.optimize;

import java.util.Collection;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.api.OptimizationAlgorithm;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.optimize.api.IterationListener;
import org.deeplearning4j.optimize.solvers.BaseOptimizer;
import org.deeplearning4j.optimize.solvers.ConjugateGradient;
import org.deeplearning4j.optimize.solvers.GradientAscent;
import org.deeplearning4j.optimize.solvers.IterationGradientDescent;
import org.deeplearning4j.optimize.solvers.LBFGS;
import org.deeplearning4j.optimize.solvers.StochasticHessianFree;

public class Solver {
    private NeuralNetConfiguration conf;
    private Collection<IterationListener> listeners;
    private Model model;
    private BaseOptimizer optimizer;

    public void optimize() {
        if (this.optimizer == null) {
            this.optimizer = this.getOptimizer();
        }
        this.optimizer.optimize();
    }

    public BaseOptimizer getOptimizer() {
        OptimizationAlgorithm algo = this.conf.getOptimizationAlgo();
        switch (algo) {
            case LBFGS: {
                return new LBFGS(this.conf, this.conf.getStepFunction(), this.listeners, this.model);
            }
            case GRADIENT_DESCENT: {
                return new GradientAscent(this.conf, this.conf.getStepFunction(), this.listeners, this.model);
            }
            case HESSIAN_FREE: {
                return new StochasticHessianFree(this.conf, this.conf.getStepFunction(), this.listeners, this.model);
            }
            case CONJUGATE_GRADIENT: {
                return new ConjugateGradient(this.conf, this.conf.getStepFunction(), this.listeners, this.model);
            }
            case ITERATION_GRADIENT_DESCENT: {
                return new IterationGradientDescent(this.conf, this.conf.getStepFunction(), this.listeners, this.model);
            }
        }
        throw new IllegalStateException("No optimizer found");
    }

    public static class Builder {
        private NeuralNetConfiguration conf;
        private Collection<IterationListener> listeners;
        private Model model;

        public Builder configure(NeuralNetConfiguration conf) {
            this.conf = conf;
            return this;
        }

        public Builder listeners(Collection<IterationListener> listeners) {
            this.listeners = listeners;
            return this;
        }

        public Builder model(Model model) {
            this.model = model;
            return this;
        }

        public Solver build() {
            Solver solver = new Solver();
            solver.conf = this.conf;
            solver.listeners = this.listeners;
            solver.model = this.model;
            return solver;
        }
    }
}

