/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.factory;

import org.deeplearning4j.models.classifiers.lstm.LSTM;
import org.deeplearning4j.models.featuredetectors.autoencoder.recursive.RecursiveAutoEncoder;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.LayerFactory;
import org.deeplearning4j.nn.layers.BasePretrainNetwork;
import org.deeplearning4j.nn.layers.convolution.ConvolutionDownSampleLayer;
import org.deeplearning4j.nn.layers.factory.ConvolutionLayerFactory;
import org.deeplearning4j.nn.layers.factory.DefaultLayerFactory;
import org.deeplearning4j.nn.layers.factory.LSTMLayerFactory;
import org.deeplearning4j.nn.layers.factory.PretrainLayerFactory;
import org.deeplearning4j.nn.layers.factory.RecursiveAutoEncoderLayerFactory;

public class LayerFactories {
    public static LayerFactory getFactory(Class<? extends Layer> clazz) {
        if (clazz.equals(ConvolutionDownSampleLayer.class)) {
            return new ConvolutionLayerFactory(clazz);
        }
        if (clazz.equals(LSTM.class)) {
            return new LSTMLayerFactory(LSTM.class);
        }
        if (RecursiveAutoEncoder.class.isAssignableFrom(clazz)) {
            return new RecursiveAutoEncoderLayerFactory(RecursiveAutoEncoder.class);
        }
        if (BasePretrainNetwork.class.isAssignableFrom(clazz)) {
            return new PretrainLayerFactory(clazz);
        }
        return new DefaultLayerFactory(clazz);
    }
}

