/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.factory;

import java.lang.reflect.Constructor;
import java.util.LinkedHashMap;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.LayerFactory;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.params.DefaultParamInitializer;
import org.nd4j.linalg.api.ndarray.INDArray;

public class DefaultLayerFactory
implements LayerFactory {
    protected Class<? extends Layer> layerClazz;

    public DefaultLayerFactory(Class<? extends Layer> layerClazz) {
        this.layerClazz = layerClazz;
    }

    public Layer create(NeuralNetConfiguration conf, int index, int numLayers) {
        return this.create(conf);
    }

    public Layer create(NeuralNetConfiguration conf) {
        Layer ret = this.getInstance(conf);
        Map<String, INDArray> params = this.getParams(conf);
        ret.setParamTable(params);
        ret.setConfiguration(conf);
        return ret;
    }

    protected Layer getInstance(NeuralNetConfiguration conf) {
        try {
            Constructor<? extends Layer> constructor = this.layerClazz.getConstructor(NeuralNetConfiguration.class);
            Layer ret = constructor.newInstance(conf);
            return ret;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected Map<String, INDArray> getParams(NeuralNetConfiguration conf) {
        ParamInitializer init = this.initializer();
        LinkedHashMap<String, INDArray> params = new LinkedHashMap<String, INDArray>();
        init.init(params, conf);
        return params;
    }

    @Override
    public String layerClazzName() {
        return this.layerClazz.getName();
    }

    @Override
    public ParamInitializer initializer() {
        return new DefaultParamInitializer();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultLayerFactory)) {
            return false;
        }
        DefaultLayerFactory that = (DefaultLayerFactory)o;
        return !(this.layerClazz != null ? !this.layerClazz.equals(that.layerClazz) : that.layerClazz != null);
    }

    public int hashCode() {
        return this.layerClazz != null ? this.layerClazz.hashCode() : 0;
    }
}

