/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution;

import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.BaseLayer;
import org.nd4j.linalg.api.activation.ActivationFunction;
import org.nd4j.linalg.api.ndarray.DimensionSlice;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ndarray.SliceOp;
import org.nd4j.linalg.convolution.Convolution;
import org.nd4j.linalg.ops.transforms.Transforms;

public class ConvolutionDownSampleLayer
extends BaseLayer {
    public ConvolutionDownSampleLayer(NeuralNetConfiguration conf) {
        super(conf);
    }

    public ConvolutionDownSampleLayer(NeuralNetConfiguration conf, INDArray input) {
        super(conf, input);
    }

    @Override
    public INDArray activate() {
        ActivationFunction f = this.conf.getActivationFunction();
        INDArray W = this.getParam("convweights");
        if (W.shape()[1] != this.input.shape()[1]) {
            throw new IllegalStateException("Input size at dimension 1 must be same as the filter size");
        }
        INDArray b = this.getParam("convbias");
        INDArray convolution = Convolution.conv2d((INDArray)this.input, (INDArray)W, (Convolution.Type)Convolution.Type.VALID);
        if (convolution.shape().length < 4) {
            int lengthDiff;
            int[] newShape = new int[4];
            for (int i = 0; i < newShape.length; ++i) {
                newShape[i] = 1;
            }
            for (int i = lengthDiff = 4 - convolution.shape().length; i < 4; ++i) {
                newShape[i] = convolution.shape()[i - lengthDiff];
            }
            convolution = convolution.reshape(newShape);
        }
        final INDArray pooled = Transforms.maxPool((INDArray)convolution, (int[])this.conf.getStride(), (boolean)true);
        INDArray bias = b.dimShuffle(new Object[]{Character.valueOf('x'), 0, Character.valueOf('x'), Character.valueOf('x')}, new int[4], new boolean[]{true});
        INDArray broadCasted = bias.broadcast(pooled.shape());
        broadCasted.iterateOverAllRows(new SliceOp(){

            public void operate(DimensionSlice nd) {
            }

            public void operate(final INDArray nd1) {
                pooled.iterateOverAllRows(new SliceOp(){

                    public void operate(DimensionSlice nd) {
                    }

                    public void operate(INDArray nd2) {
                        nd1.addi(nd2);
                    }
                });
            }
        });
        return (INDArray)f.apply((Object)pooled);
    }

    @Override
    public void update(Gradient gradient) {
    }

    @Override
    public double score() {
        return 0.0;
    }

    @Override
    public INDArray transform(INDArray data) {
        return this.activate(data);
    }

    @Override
    public void setParams(INDArray params) {
    }

    @Override
    public void iterate(INDArray input) {
    }

    @Override
    public Gradient getGradient() {
        return null;
    }

    @Override
    public void fit() {
    }

    @Override
    public void fit(INDArray input) {
    }
}

