/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.clustering.vptree;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.deeplearning4j.clustering.vptree.VpTreePoint;
import org.nd4j.linalg.api.ndarray.DimensionSlice;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ndarray.SliceOp;
import org.nd4j.linalg.distancefunction.DistanceFunction;
import org.nd4j.linalg.distancefunction.EuclideanDistance;

public class VpTreePointINDArray
implements VpTreePoint<VpTreePointINDArray> {
    private INDArray data;
    private DistanceFunction distanceFunction;
    private int index = 0;

    public VpTreePointINDArray(INDArray data, int index) {
        if (!data.isVector()) {
            throw new IllegalArgumentException("Data should only be a vector");
        }
        this.data = data;
        this.distanceFunction = new EuclideanDistance(data);
        this.index = index;
    }

    public VpTreePointINDArray(INDArray data) {
        if (!data.isVector()) {
            throw new IllegalArgumentException("Data should only be a vector");
        }
        this.data = data;
        this.distanceFunction = new EuclideanDistance(data);
    }

    @Override
    public double distance(VpTreePointINDArray p) {
        return ((Float)this.distanceFunction.apply((Object)p.data)).floatValue();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VpTreePointINDArray)) {
            return false;
        }
        VpTreePointINDArray that = (VpTreePointINDArray)o;
        return !(this.data != null ? !this.data.equals(that.data) : that.data != null);
    }

    public static List<VpTreePointINDArray> dataPoints(INDArray matrix) {
        final ArrayList<VpTreePointINDArray> ret = new ArrayList<VpTreePointINDArray>();
        final AtomicInteger count = new AtomicInteger(0);
        matrix.iterateOverAllRows(new SliceOp(){

            public void operate(DimensionSlice nd) {
            }

            public void operate(INDArray nd) {
                ret.add(new VpTreePointINDArray(nd, count.get()));
                count.incrementAndGet();
            }
        });
        return ret;
    }

    public int hashCode() {
        int result = this.data != null ? this.data.hashCode() : 0;
        result = 31 * result + (this.distanceFunction != null ? this.distanceFunction.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.data != null ? this.data.toString() : "[]";
    }

    public INDArray getData() {
        return this.data;
    }

    public void setData(INDArray data) {
        this.data = data;
    }

    public DistanceFunction getDistanceFunction() {
        return this.distanceFunction;
    }

    public void setDistanceFunction(DistanceFunction distanceFunction) {
        this.distanceFunction = distanceFunction;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

