/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.clustering.vptree;

import org.deeplearning4j.clustering.vptree.VpTreePoint;

public class VpTreePoint2D
implements VpTreePoint<VpTreePoint2D> {
    public final double x;
    public final double y;

    public VpTreePoint2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public double distance(VpTreePoint2D p) {
        double dx = this.x - p.x;
        double dy = this.y - p.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VpTreePoint2D that = (VpTreePoint2D)o;
        if (Double.compare(that.x, this.x) != 0) {
            return false;
        }
        return Double.compare(that.y, this.y) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.x);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

