/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers;

import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.distribution.UniformRealDistribution;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.layers.BaseLayer;
import org.nd4j.linalg.api.activation.ActivationFunction;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.convolution.Convolution;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.ops.transforms.Transforms;
import org.nd4j.linalg.util.ArrayUtil;

public class ConvolutionDownSampleLayer
extends BaseLayer {
    public ConvolutionDownSampleLayer(NeuralNetConfiguration conf, INDArray W, INDArray b, INDArray input) {
        super(conf, W, b, input);
    }

    public ConvolutionDownSampleLayer(NeuralNetConfiguration conf) {
        super(conf, null, null, null);
    }

    @Override
    protected INDArray createBias() {
        return Nd4j.zeros((int)this.conf.getFilterSize()[0]);
    }

    @Override
    protected INDArray createWeightMatrix() {
        float prod = ArrayUtil.prod((int[])ArrayUtil.removeIndex((int[])this.conf.getWeightShape(), (int)0));
        float min = -1.0f / prod;
        float max = 1.0f / prod;
        UniformRealDistribution dist = new UniformRealDistribution(this.conf.getRng(), (double)min, (double)max);
        return Nd4j.rand((int[])this.conf.getWeightShape(), (RealDistribution)dist);
    }

    @Override
    public INDArray activate(INDArray input) {
        ActivationFunction f = this.conf.getActivationFunction();
        INDArray convolution = Convolution.conv2d((INDArray)input, (INDArray)this.getW(), (Convolution.Type)Convolution.Type.VALID);
        INDArray pooled = Transforms.maxPool((INDArray)convolution, (int[])this.conf.getFilterSize(), (boolean)true);
        INDArray bias = this.b.dimShuffle(new Object[]{Character.valueOf('x'), 0, Character.valueOf('x'), Character.valueOf('x')}, new int[]{0}, new boolean[]{false});
        pooled.addi(bias.broadcast(pooled.shape()));
        return (INDArray)f.apply((Object)pooled);
    }
}

