/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.optimize.optimizers;

import java.io.Serializable;
import org.deeplearning4j.nn.BaseMultiLayerNetwork;
import org.deeplearning4j.nn.api.NeuralNetwork;
import org.deeplearning4j.optimize.api.IterationListener;
import org.deeplearning4j.optimize.api.OptimizableByGradientValueMatrix;
import org.deeplearning4j.optimize.api.StepFunction;
import org.deeplearning4j.optimize.api.TrainingEvaluator;
import org.deeplearning4j.optimize.solvers.StochasticHessianFree;
import org.deeplearning4j.optimize.solvers.VectorizedDeepLearningGradientAscent;
import org.deeplearning4j.optimize.solvers.VectorizedNonZeroStoppingConjugateGradient;
import org.deeplearning4j.optimize.stepfunctions.BackPropStepFunction;
import org.deeplearning4j.plot.NeuralNetPlotter;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.api.DataSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackPropOptimizer
implements Serializable,
OptimizableByGradientValueMatrix,
IterationListener {
    private BaseMultiLayerNetwork network;
    private int length = -1;
    private double lr = 0.1f;
    private int iterations = 1000;
    private static Logger log = LoggerFactory.getLogger(BackPropOptimizer.class);
    private int currentIteration = -1;
    protected NeuralNetPlotter plotter = new NeuralNetPlotter();

    public BackPropOptimizer(BaseMultiLayerNetwork network, double lr, int epochs) {
        this.network = network;
        this.lr = lr;
        this.iterations = epochs;
    }

    @Override
    public void setCurrentIteration(int value) {
        this.currentIteration = value;
    }

    public void optimize(TrainingEvaluator eval) {
        this.lineSearchBackProp(eval);
        this.network.getOutputLayer().fit((DataSet)new org.nd4j.linalg.dataset.DataSet(this.network.getOutputLayer().getInput(), this.network.getOutputLayer().getLabels()));
    }

    private void lineSearchBackProp(TrainingEvaluator eval) {
        NeuralNetwork.OptimizationAlgorithm optimizationAlgorithm = this.network.getDefaultConfiguration().getOptimizationAlgo();
        this.network.feedForward();
        if (optimizationAlgorithm == NeuralNetwork.OptimizationAlgorithm.CONJUGATE_GRADIENT) {
            VectorizedNonZeroStoppingConjugateGradient g = new VectorizedNonZeroStoppingConjugateGradient((OptimizableByGradientValueMatrix)this, (StepFunction)new BackPropStepFunction(this.network), (IterationListener)this);
            g.setTrainingEvaluator(eval);
            if (this.network.getOutputLayer().conf().getRenderWeightIterations() > 0) {
                // empty if block
            }
            g.setMaxIterations(this.network.getOutputLayer().conf().getNumIterations());
            g.optimize(this.network.getOutputLayer().conf().getNumIterations());
        } else if (optimizationAlgorithm == NeuralNetwork.OptimizationAlgorithm.HESSIAN_FREE) {
            StochasticHessianFree s = new StochasticHessianFree(this, this.network);
            s.setTrainingEvaluator(eval);
            s.setMaxIterations(this.network.getOutputLayer().conf().getNumIterations());
            s.optimize(this.network.getOutputLayer().conf().getNumIterations());
        } else {
            VectorizedDeepLearningGradientAscent g = new VectorizedDeepLearningGradientAscent(this, 0.1, this, new BackPropStepFunction(this.network));
            g.setTrainingEvaluator(eval);
            g.optimize(this.network.getOutputLayer().conf().getNumIterations());
        }
    }

    @Override
    public double getValue() {
        return -this.network.score();
    }

    @Override
    public int getNumParameters() {
        if (this.length < 0) {
            this.length = this.getParameters().length();
        }
        return this.length;
    }

    @Override
    public void setParameter(int index, double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray getParameters() {
        return this.network.params();
    }

    @Override
    public double getParameter(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setParameters(INDArray params) {
        this.network.setParameters(params);
    }

    @Override
    public INDArray getValueGradient(int iteration) {
        return this.network.pack(this.network.backPropGradient());
    }

    @Override
    public void iterationDone(int iteration) {
        int plotIterations = this.network.getOutputLayer().conf().getRenderWeightIterations();
        if (plotIterations <= 0) {
            return;
        }
        if (iteration % plotIterations == 0) {
            this.plotter.plotNetworkGradient(this.network.getOutputLayer(), this.getValueGradient(0), 100);
        }
    }
}

