/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.optimize.optimizers;

import java.io.Serializable;
import org.deeplearning4j.nn.BaseMultiLayerNetwork;
import org.deeplearning4j.nn.api.NeuralNetwork;
import org.deeplearning4j.optimize.api.OptimizableByGradientValueMatrix;
import org.deeplearning4j.optimize.api.TrainingEvaluator;
import org.deeplearning4j.optimize.solvers.StochasticHessianFree;
import org.deeplearning4j.optimize.solvers.VectorizedDeepLearningGradientAscent;
import org.deeplearning4j.optimize.solvers.VectorizedNonZeroStoppingConjugateGradient;
import org.deeplearning4j.optimize.stepfunctions.BackPropStepFunction;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.api.DataSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackPropOptimizer
implements Serializable,
OptimizableByGradientValueMatrix {
    private BaseMultiLayerNetwork network;
    private int length = -1;
    private double lr = 0.1f;
    private int iterations = 1000;
    private static Logger log = LoggerFactory.getLogger(BackPropOptimizer.class);
    private int currentIteration = -1;

    public BackPropOptimizer(BaseMultiLayerNetwork network, double lr, int epochs) {
        this.network = network;
        this.lr = lr;
        this.iterations = epochs;
    }

    @Override
    public void setCurrentIteration(int value) {
        this.currentIteration = value;
    }

    public void optimize(TrainingEvaluator eval, boolean lineSearch) {
        this.lineSearchBackProp(eval);
        this.network.getOutputLayer().fit((DataSet)new org.nd4j.linalg.dataset.DataSet(this.network.getOutputLayer().getInput(), this.network.getOutputLayer().getLabels()));
    }

    private void lineSearchBackProp(TrainingEvaluator eval) {
        NeuralNetwork.OptimizationAlgorithm optimizationAlgorithm = this.network.getDefaultConfiguration().getOptimizationAlgo();
        if (optimizationAlgorithm == NeuralNetwork.OptimizationAlgorithm.CONJUGATE_GRADIENT) {
            VectorizedNonZeroStoppingConjugateGradient g = new VectorizedNonZeroStoppingConjugateGradient((OptimizableByGradientValueMatrix)this, new BackPropStepFunction(this.network));
            g.setTrainingEvaluator(eval);
            g.setMaxIterations(this.iterations);
            g.optimize(this.iterations);
        } else if (optimizationAlgorithm == NeuralNetwork.OptimizationAlgorithm.HESSIAN_FREE) {
            StochasticHessianFree s = new StochasticHessianFree(this, this.network);
            s.setTrainingEvaluator(eval);
            s.setMaxIterations(this.iterations);
            s.optimize(this.iterations);
        } else {
            VectorizedDeepLearningGradientAscent g = new VectorizedDeepLearningGradientAscent((OptimizableByGradientValueMatrix)this, new BackPropStepFunction(this.network));
            g.setTrainingEvaluator(eval);
            g.optimize(this.iterations);
        }
    }

    @Override
    public double getValue() {
        return -this.network.score();
    }

    @Override
    public int getNumParameters() {
        if (this.length < 0) {
            this.length = this.getParameters().length();
        }
        return this.length;
    }

    @Override
    public void setParameter(int index, double value) {
    }

    @Override
    public INDArray getParameters() {
        return this.network.params();
    }

    @Override
    public double getParameter(int index) {
        return 0.0;
    }

    @Override
    public void setParameters(INDArray params) {
        this.network.setParameters(params);
    }

    @Override
    public INDArray getValueGradient(int iteration) {
        return this.network.pack(this.network.backPropGradient());
    }
}

