/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.featuredetectors.autoencoder;

import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.nn.BaseNeuralNetwork;
import org.deeplearning4j.nn.api.NeuralNetwork;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.NeuralNetworkGradient;
import org.deeplearning4j.optimize.optimizers.autoencoder.AutoEncoderOptimizer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.ops.transforms.Transforms;

public class AutoEncoder
extends BaseNeuralNetwork {
    private AutoEncoder() {
    }

    public AutoEncoder(INDArray input, INDArray W, INDArray hbias, INDArray vbias, NeuralNetConfiguration conf) {
        super(input, W, hbias, vbias, conf);
    }

    @Override
    public INDArray transform(INDArray x) {
        return this.getReconstructedInput(x);
    }

    @Override
    public INDArray hiddenActivation(INDArray input) {
        return this.getHiddenValues(input);
    }

    @Override
    public void iterate(INDArray input, Object[] params) {
        NeuralNetworkGradient gradient = this.getGradient(new Object[]{Float.valueOf(this.conf.getLr())});
        this.vBias.addi(gradient.getvBiasGradient());
        this.W.addi(gradient.getwGradient());
        this.hBias.addi(gradient.gethBiasGradient());
    }

    @Override
    public NeuralNetworkGradient getGradient(Object[] params) {
        double lr = (Double)params[0];
        int iterations = (Integer)params[1];
        INDArray out = this.transform(this.input);
        INDArray diff = this.input.sub(out);
        INDArray wGradient = diff.transpose().mmul(this.W);
        INDArray hBiasGradient = wGradient.sum(1);
        INDArray vBiasGradient = Nd4j.zeros((int)this.vBias.rows(), (int)this.vBias.columns());
        NeuralNetworkGradient ret = new NeuralNetworkGradient(wGradient, vBiasGradient, hBiasGradient);
        this.updateGradientAccordingToParams(ret, iterations, lr);
        return ret;
    }

    public INDArray getHiddenValues(INDArray x) {
        INDArray preAct;
        if (this.conf.isConcatBiases()) {
            INDArray concat = Nd4j.vstack((INDArray[])new INDArray[]{this.W, this.hBias.transpose()});
            preAct = x.mmul(concat);
        } else {
            preAct = x.mmul(this.W).addiRowVector(this.hBias);
        }
        INDArray ret = Transforms.sigmoid((INDArray)preAct);
        this.applyDropOutIfNecessary(ret);
        return ret;
    }

    public INDArray getReconstructedInput(INDArray y) {
        if (this.conf.isConcatBiases()) {
            INDArray preAct = y.mmul(this.W.transpose());
            preAct = Nd4j.hstack((INDArray[])new INDArray[]{preAct, Nd4j.ones((int)preAct.rows(), (int)1)});
            return Transforms.sigmoid((INDArray)preAct);
        }
        INDArray preAct = y.mmul(this.W.transpose());
        preAct.addiRowVector(this.vBias);
        return Transforms.sigmoid((INDArray)preAct);
    }

    @Override
    public Pair<INDArray, INDArray> sampleHiddenGivenVisible(INDArray v) {
        INDArray out = this.transform(v);
        return new Pair<INDArray, INDArray>(out, out);
    }

    @Override
    public Pair<INDArray, INDArray> sampleVisibleGivenHidden(INDArray h) {
        INDArray out = this.transform(h);
        return new Pair<INDArray, INDArray>(out, out);
    }

    @Override
    public void fit(INDArray input, Object[] params) {
        AutoEncoderOptimizer o = new AutoEncoderOptimizer((NeuralNetwork)this, this.conf.getLr(), params, this.conf.getOptimizationAlgo(), this.conf.getLossFunction());
        o.train(input);
    }

    public static class Builder
    extends BaseNeuralNetwork.Builder<AutoEncoder> {
        public Builder() {
            this.clazz = AutoEncoder.class;
        }

        @Override
        public AutoEncoder build() {
            AutoEncoder ret = (AutoEncoder)super.build();
            return ret;
        }
    }
}

